/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.ProviderSynchronization;
import org.apache.qpid.jms.util.IOExceptionSupport;

public abstract class ProviderFuture
implements AsyncResult {
    protected final ProviderSynchronization synchronization;
    protected static final int INCOMPLETE = 0;
    protected static final int COMPLETING = 1;
    protected static final int SUCCESS = 2;
    protected static final int FAILURE = 3;
    protected static final AtomicIntegerFieldUpdater<ProviderFuture> STATE_FIELD_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ProviderFuture.class, "state");
    private volatile int state = 0;
    protected Throwable error;
    protected int waiting;

    public ProviderFuture() {
        this(null);
    }

    public ProviderFuture(ProviderSynchronization synchronization) {
        this.synchronization = synchronization;
    }

    @Override
    public boolean isComplete() {
        return this.state > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(Throwable result) {
        if (STATE_FIELD_UPDATER.compareAndSet(this, 0, 1)) {
            this.error = result;
            if (this.synchronization != null) {
                this.synchronization.onPendingFailure(this.error);
            }
            STATE_FIELD_UPDATER.lazySet(this, 3);
            ProviderFuture providerFuture = this;
            synchronized (providerFuture) {
                if (this.waiting > 0) {
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess() {
        if (STATE_FIELD_UPDATER.compareAndSet(this, 0, 1)) {
            if (this.synchronization != null) {
                this.synchronization.onPendingSuccess();
            }
            STATE_FIELD_UPDATER.lazySet(this, 2);
            ProviderFuture providerFuture = this;
            synchronized (providerFuture) {
                if (this.waiting > 0) {
                    this.notifyAll();
                }
            }
        }
    }

    public abstract void sync() throws IOException;

    public abstract boolean sync(long var1, TimeUnit var3) throws IOException;

    protected void failOnError() throws IOException {
        Throwable cause = this.error;
        if (cause != null) {
            throw IOExceptionSupport.create(cause);
        }
    }
}

