/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.meta;

import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsRedeliveryPolicy;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsResourceVistor;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.util.ToStringSupport;

public final class JmsConsumerInfo
implements JmsResource,
Comparable<JmsConsumerInfo> {
    protected final JmsConsumerId consumerId;
    protected JmsDestination destination;
    protected int prefetchSize;
    protected boolean browser;
    protected String selector;
    protected String clientId;
    protected String subscriptionName;
    protected boolean noLocal;
    protected int acknowledgementMode;
    protected boolean localMessageExpiry;
    protected JmsRedeliveryPolicy redeliveryPolicy;
    private transient long lastDeliveredSequenceId;

    public JmsConsumerInfo(JmsConsumerId consumerId) {
        if (consumerId == null) {
            throw new IllegalArgumentException("Consumer ID cannot be null");
        }
        this.consumerId = consumerId;
    }

    public JmsConsumerInfo(JmsSessionInfo sessionInfo, long consumerId) {
        if (sessionInfo == null) {
            throw new IllegalArgumentException("Session info object cannot be null");
        }
        this.consumerId = new JmsConsumerId(sessionInfo.getSessionId(), consumerId);
    }

    public JmsConsumerInfo copy() {
        JmsConsumerInfo info = new JmsConsumerInfo(this.consumerId);
        this.copy(info);
        return info;
    }

    private void copy(JmsConsumerInfo info) {
        info.destination = this.destination;
        info.prefetchSize = this.prefetchSize;
        info.browser = this.browser;
        info.selector = this.selector;
        info.clientId = this.clientId;
        info.subscriptionName = this.subscriptionName;
        info.noLocal = this.noLocal;
        info.acknowledgementMode = this.acknowledgementMode;
        info.lastDeliveredSequenceId = this.lastDeliveredSequenceId;
    }

    public boolean isDurable() {
        return this.subscriptionName != null;
    }

    public JmsConsumerId getConsumerId() {
        return this.consumerId;
    }

    public boolean isBrowser() {
        return this.browser;
    }

    public void setBrowser(boolean browser) {
        this.browser = browser;
    }

    public JmsDestination getDestination() {
        return this.destination;
    }

    public void setDestination(JmsDestination destination) {
        this.destination = destination;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String durableSubscriptionId) {
        this.subscriptionName = durableSubscriptionId;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public void setLastDeliveredSequenceId(long lastDeliveredSequenceId) {
        this.lastDeliveredSequenceId = lastDeliveredSequenceId;
    }

    public long getLastDeliveredSequenceId() {
        return this.lastDeliveredSequenceId;
    }

    public JmsSessionId getParentId() {
        return this.consumerId.getParentId();
    }

    public int getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public void setAcknowledgementMode(int acknowledgementMode) {
        this.acknowledgementMode = acknowledgementMode;
    }

    public boolean isLocalMessageExpiry() {
        return this.localMessageExpiry;
    }

    public void setLocalMessageExpiry(boolean localMessageExpiry) {
        this.localMessageExpiry = localMessageExpiry;
    }

    public JmsRedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(JmsRedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public String toString() {
        return ToStringSupport.toString(this);
    }

    public int hashCode() {
        return this.consumerId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JmsConsumerInfo other = (JmsConsumerInfo)obj;
        return this.consumerId.equals(other.consumerId);
    }

    @Override
    public int compareTo(JmsConsumerInfo other) {
        return this.consumerId.compareTo(other.consumerId);
    }

    @Override
    public void visit(JmsResourceVistor vistor) throws Exception {
        vistor.processConsumerInfo(this);
    }
}

