/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.meta;

import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsResourceVistor;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.util.ToStringSupport;

public final class JmsProducerInfo
implements JmsResource,
Comparable<JmsProducerInfo> {
    protected final JmsProducerId producerId;
    protected JmsDestination destination;

    public JmsProducerInfo(JmsProducerId producerId) {
        if (producerId == null) {
            throw new IllegalArgumentException("Producer ID cannot be null");
        }
        this.producerId = producerId;
    }

    public JmsProducerInfo(JmsSessionInfo sessionInfo, long producerId) {
        if (sessionInfo == null) {
            throw new IllegalArgumentException("Parent Session Info object cannot be null");
        }
        this.producerId = new JmsProducerId(sessionInfo.getSessionId(), producerId);
    }

    public JmsProducerInfo copy() {
        JmsProducerInfo info = new JmsProducerInfo(this.producerId);
        this.copy(info);
        return info;
    }

    public void copy(JmsProducerInfo info) {
        info.destination = this.destination;
    }

    public JmsProducerId getProducerId() {
        return this.producerId;
    }

    public JmsSessionId getParentId() {
        return this.producerId.getParentId();
    }

    public JmsDestination getDestination() {
        return this.destination;
    }

    public void setDestination(JmsDestination destination) {
        this.destination = destination;
    }

    public String toString() {
        return ToStringSupport.toString(this);
    }

    public int hashCode() {
        return this.producerId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JmsProducerInfo other = (JmsProducerInfo)obj;
        return this.producerId.equals(other.producerId);
    }

    @Override
    public int compareTo(JmsProducerInfo other) {
        return this.producerId.compareTo(other.producerId);
    }

    @Override
    public void visit(JmsResourceVistor vistor) throws Exception {
        vistor.processProducerInfo(this);
    }
}

