/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.WrappedAsyncResult;
import org.apache.qpid.jms.util.IOExceptionSupport;

public class ProviderFuture
extends WrappedAsyncResult {
    protected final CountDownLatch latch = new CountDownLatch(1);
    protected volatile Throwable error;

    public ProviderFuture() {
        super(null);
    }

    public ProviderFuture(AsyncResult watcher) {
        super(watcher);
    }

    @Override
    public boolean isComplete() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public void onFailure(Throwable result) {
        if (this.error == null) {
            this.error = result;
            this.latch.countDown();
            super.onFailure(result);
        }
    }

    @Override
    public void onSuccess() {
        this.latch.countDown();
        super.onSuccess();
    }

    public void sync(long amount, TimeUnit unit) throws IOException {
        try {
            this.latch.await(amount, unit);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw IOExceptionSupport.create(e);
        }
        this.failOnError();
    }

    public void sync() throws IOException {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw IOExceptionSupport.create(e);
        }
        this.failOnError();
    }

    private void failOnError() throws IOException {
        Throwable cause = this.error;
        if (cause != null) {
            throw IOExceptionSupport.create(cause);
        }
    }
}

