/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsTemporaryDestination;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpAbstractResource;
import org.apache.qpid.jms.provider.amqp.AmqpConnectionProperties;
import org.apache.qpid.jms.provider.amqp.AmqpConnectionSession;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpSaslAuthenticator;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.jms.provider.amqp.AmqpTemporaryDestination;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFactory;
import org.apache.qpid.jms.util.IOExceptionSupport;
import org.apache.qpid.jms.util.MetaDataSupport;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpConnection
extends AmqpAbstractResource<JmsConnectionInfo, Connection> {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpConnection.class);
    private final AmqpJmsMessageFactory amqpMessageFactory;
    private final URI remoteURI;
    private final Map<JmsSessionId, AmqpSession> sessions = new HashMap<JmsSessionId, AmqpSession>();
    private final Map<JmsDestination, AmqpTemporaryDestination> tempDests = new HashMap<JmsDestination, AmqpTemporaryDestination>();
    private final AmqpProvider provider;
    private AmqpSaslAuthenticator authenticator;
    private final AmqpConnectionSession connectionSession;
    private final AmqpConnectionProperties properties;
    private boolean objectMessageUsesAmqpTypes = false;
    private boolean anonymousProducerCache = false;
    private int anonymousProducerCacheSize = 10;

    public AmqpConnection(AmqpProvider provider, Connection protonConnection, AmqpSaslAuthenticator authenticator, JmsConnectionInfo info) {
        super(info, protonConnection);
        this.provider = provider;
        this.remoteURI = provider.getRemoteURI();
        this.amqpMessageFactory = new AmqpJmsMessageFactory(this);
        this.authenticator = authenticator;
        ((JmsConnectionInfo)this.resource).getConnectionId().setProviderHint(this);
        this.properties = new AmqpConnectionProperties(info);
        JmsSessionInfo sessionInfo = new JmsSessionInfo((JmsConnectionInfo)this.resource, -1L);
        sessionInfo.setAcknowledgementMode(1);
        this.connectionSession = new AmqpConnectionSession(this, sessionInfo);
    }

    @Override
    protected void doOpen() {
        String hostname = this.provider.getVhost();
        if (hostname == null) {
            hostname = this.remoteURI.getHost();
        } else if (hostname.isEmpty()) {
            hostname = null;
        }
        LinkedHashMap<Symbol, String> props = new LinkedHashMap<Symbol, String>();
        props.put(AmqpSupport.PRODUCT, "QpidJMS");
        props.put(AmqpSupport.VERSION, MetaDataSupport.PROVIDER_VERSION);
        props.put(AmqpSupport.PLATFORM, MetaDataSupport.PLATFORM_DETAILS);
        Connection conn = (Connection)this.getEndpoint();
        conn.setHostname(hostname);
        conn.setContainer(((JmsConnectionInfo)this.resource).getClientId());
        conn.setDesiredCapabilities(new Symbol[]{AmqpSupport.SOLE_CONNECTION_CAPABILITY});
        conn.setProperties(props);
        super.doOpen();
    }

    public AmqpSession createSession(JmsSessionInfo sessionInfo) {
        AmqpSession session = new AmqpSession(this, sessionInfo);
        return session;
    }

    public AmqpTemporaryDestination createTemporaryDestination(JmsTemporaryDestination destination) {
        AmqpTemporaryDestination temporary = new AmqpTemporaryDestination(this.connectionSession, destination);
        return temporary;
    }

    public AmqpTemporaryDestination getTemporaryDestination(JmsTemporaryDestination destination) {
        return this.tempDests.get(destination);
    }

    public void unsubscribe(String subscriptionName, AsyncResult request) {
        for (AmqpSession session : this.sessions.values()) {
            if (!session.containsSubscription(subscriptionName)) continue;
            request.onFailure((Throwable)new JMSException("Cannot remove an active durable subscription"));
            return;
        }
        this.connectionSession.unsubscribe(subscriptionName, request);
    }

    @Override
    protected void doOpenCompletion() {
        this.properties.initialize(((Connection)this.getEndpoint()).getRemoteOfferedCapabilities(), ((Connection)this.getEndpoint()).getRemoteProperties());
        if (!this.properties.isConnectionOpenFailed()) {
            this.connectionSession.open(new AsyncResult(){

                @Override
                public boolean isComplete() {
                    return AmqpConnection.this.connectionSession.isOpen();
                }

                @Override
                public void onSuccess() {
                    LOG.debug("{} is now open: ", (Object)AmqpConnection.this);
                    AmqpConnection.this.opened();
                }

                @Override
                public void onFailure(Throwable result) {
                    LOG.debug("AMQP Connection Session failed to open.");
                    AmqpConnection.this.failed(IOExceptionSupport.create(result));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSaslAuthentication() {
        if (this.authenticator == null) {
            return;
        }
        try {
            if (this.authenticator.authenticate()) {
                this.authenticator = null;
            }
        }
        catch (JMSSecurityException ex) {
            try {
                Transport t = ((Connection)this.getEndpoint()).getTransport();
                t.close_head();
            }
            finally {
                this.failed((Exception)((Object)ex));
            }
        }
    }

    void addTemporaryDestination(AmqpTemporaryDestination destination) {
        this.tempDests.put(destination.getJmsDestination(), destination);
    }

    void removeTemporaryDestination(AmqpTemporaryDestination destination) {
        this.tempDests.remove(destination.getJmsDestination());
    }

    void addSession(AmqpSession session) {
        this.sessions.put(session.getSessionId(), session);
    }

    void removeSession(AmqpSession session) {
        this.sessions.remove(session.getSessionId());
    }

    public JmsConnectionInfo getConnectionInfo() {
        return (JmsConnectionInfo)this.resource;
    }

    public Connection getProtonConnection() {
        return (Connection)this.getEndpoint();
    }

    public URI getRemoteURI() {
        return this.remoteURI;
    }

    public String getUsername() {
        return ((JmsConnectionInfo)this.resource).getUsername();
    }

    public String getPassword() {
        return ((JmsConnectionInfo)this.resource).getPassword();
    }

    public AmqpProvider getProvider() {
        return this.provider;
    }

    public String getQueuePrefix() {
        return this.properties.getQueuePrefix();
    }

    public void setQueuePrefix(String queuePrefix) {
        this.properties.setQueuePrefix(queuePrefix);
    }

    public String getTopicPrefix() {
        return this.properties.getTopicPrefix();
    }

    public void setTopicPrefix(String topicPrefix) {
        this.properties.setTopicPrefix(topicPrefix);
    }

    public AmqpSession getSession(JmsSessionId sessionId) {
        if (sessionId.getProviderHint() instanceof AmqpSession) {
            return (AmqpSession)sessionId.getProviderHint();
        }
        return this.sessions.get(sessionId);
    }

    public boolean isPresettleConsumers() {
        return this.provider.isPresettleConsumers();
    }

    public boolean isPresettleProducers() {
        return this.provider.isPresettleProducers();
    }

    public boolean isAnonymousProducerCache() {
        return this.anonymousProducerCache;
    }

    public void setAnonymousProducerCache(boolean anonymousProducerCache) {
        this.anonymousProducerCache = anonymousProducerCache;
    }

    public int getAnonymousProducerCacheSize() {
        return this.anonymousProducerCacheSize;
    }

    public void setAnonymousProducerCacheSize(int anonymousProducerCacheSize) {
        this.anonymousProducerCacheSize = anonymousProducerCacheSize;
    }

    public boolean isObjectMessageUsesAmqpTypes() {
        return this.objectMessageUsesAmqpTypes;
    }

    public void setObjectMessageUsesAmqpTypes(boolean objectMessageUsesAmqpTypes) {
        this.objectMessageUsesAmqpTypes = objectMessageUsesAmqpTypes;
    }

    public AmqpJmsMessageFactory getAmqpMessageFactory() {
        return this.amqpMessageFactory;
    }

    public AmqpConnectionProperties getProperties() {
        return this.properties;
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay) {
        if (task == null) {
            LOG.trace("Resource attempted to schedule a null task.");
            return null;
        }
        return this.getProvider().getScheduler().schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return "AmqpConnection { " + this.getConnectionInfo().getConnectionId() + " }";
    }
}

