/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.util.HashMap;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsTemporaryDestination;
import org.apache.qpid.jms.provider.amqp.AmqpAbstractResource;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.message.AmqpDestinationHelper;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.DeleteOnClose;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpTemporaryDestination
extends AmqpAbstractResource<JmsTemporaryDestination, Sender> {
    public static final Symbol DYNAMIC_NODE_LIFETIME_POLICY = Symbol.valueOf((String)"lifetime-policy");
    private static final String TEMP_QUEUE_CREATOR = "temp-queue-creator:";
    private static final String TEMP_TOPIC_CREATOR = "temp-topic-creator:";
    private static final Logger LOG = LoggerFactory.getLogger(AmqpTemporaryDestination.class);
    private final AmqpConnection connection;
    private final AmqpSession session;

    public AmqpTemporaryDestination(AmqpSession session, JmsTemporaryDestination destination) {
        super(destination);
        this.session = session;
        this.connection = session.getConnection();
    }

    @Override
    public void opened() {
        String oldDestinationName = ((JmsTemporaryDestination)this.resource).getName();
        String destinationName = ((Sender)this.getEndpoint()).getRemoteTarget().getAddress();
        ((JmsTemporaryDestination)this.resource).setName(destinationName);
        LOG.trace("Updated temp destination to: {} from: {}", (Object)this.resource, (Object)oldDestinationName);
        this.connection.addTemporaryDestination(this);
        super.opened();
    }

    @Override
    protected void doOpen() {
        String localDestinationName = ((JmsTemporaryDestination)this.resource).getName();
        String senderLinkName = null;
        senderLinkName = ((JmsTemporaryDestination)this.resource).isQueue() ? "qpid-jms:temp-queue-creator:" + localDestinationName : "qpid-jms:temp-topic-creator:" + localDestinationName;
        Source source = new Source();
        Target target = new Target();
        target.setDynamic(true);
        target.setDurable(TerminusDurability.NONE);
        target.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
        HashMap<Symbol, DeleteOnClose> dynamicNodeProperties = new HashMap<Symbol, DeleteOnClose>();
        dynamicNodeProperties.put(DYNAMIC_NODE_LIFETIME_POLICY, DeleteOnClose.getInstance());
        target.setDynamicNodeProperties(dynamicNodeProperties);
        if (((JmsTemporaryDestination)this.resource).isQueue()) {
            target.setCapabilities(new Symbol[]{AmqpDestinationHelper.TEMP_QUEUE_CAPABILITY});
        } else {
            target.setCapabilities(new Symbol[]{AmqpDestinationHelper.TEMP_TOPIC_CAPABILITY});
        }
        Sender sender = this.session.getProtonSession().sender(senderLinkName);
        sender.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        sender.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
        sender.setSenderSettleMode(SenderSettleMode.UNSETTLED);
        sender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        this.setEndpoint(sender);
        super.doOpen();
    }

    @Override
    protected void doOpenCompletion() {
        org.apache.qpid.proton.amqp.transport.Target target = ((Sender)this.getEndpoint()).getRemoteTarget();
        if (target != null) {
            super.doOpenCompletion();
        }
    }

    @Override
    protected void doClose() {
        this.connection.removeTemporaryDestination(this);
        super.doClose();
    }

    public AmqpConnection getConnection() {
        return this.connection;
    }

    public AmqpSession getSession() {
        return this.session;
    }

    public Sender getProtonSender() {
        return (Sender)this.getEndpoint();
    }

    public JmsDestination getJmsDestination() {
        return (JmsDestination)((Object)this.resource);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " { " + this.resource + "}";
    }
}

