/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataSupport {
    private static final Logger LOG;
    public static final String PROVIDER_NAME = "QpidJMS";
    public static final String PROVIDER_VERSION;
    public static final int PROVIDER_MAJOR_VERSION;
    public static final int PROVIDER_MINOR_VERSION;
    public static final String PLATFORM_DETAILS;

    private static String buildPlatformDetails() {
        String details = "unknown";
        try {
            StringBuilder platformInfo = new StringBuilder("JVM: ");
            platformInfo.append(System.getProperty("java.version"));
            platformInfo.append(", ");
            platformInfo.append(System.getProperty("java.vm.version"));
            platformInfo.append(", ");
            platformInfo.append(System.getProperty("java.vendor"));
            platformInfo.append(", OS: ");
            platformInfo.append(System.getProperty("os.name"));
            platformInfo.append(", ");
            platformInfo.append(System.getProperty("os.version"));
            platformInfo.append(", ");
            platformInfo.append(System.getProperty("os.arch"));
            details = platformInfo.toString();
        }
        catch (Throwable e) {
            LOG.trace("Problem generating platform details string", e);
        }
        return details;
    }

    static {
        int minor;
        int major;
        String version;
        block7: {
            LOG = LoggerFactory.getLogger(MetaDataSupport.class);
            PLATFORM_DETAILS = MetaDataSupport.buildPlatformDetails();
            version = "unknown";
            major = 0;
            minor = 0;
            try {
                Package p = Package.getPackage(MetaDataSupport.class.getPackage().getName());
                if (p != null) {
                    version = p.getImplementationVersion();
                    Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+).*");
                    Matcher m = pattern.matcher(version);
                    if (m.matches()) {
                        major = Integer.parseInt(m.group(1));
                        minor = Integer.parseInt(m.group(2));
                    }
                }
            }
            catch (Throwable e) {
                LOG.trace("Problem generating primary version details", e);
                InputStream in = null;
                String path = MetaDataSupport.class.getPackage().getName().replace(".", "/");
                in = MetaDataSupport.class.getResourceAsStream("/" + path + "/version.txt");
                if (in == null) break block7;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.US_ASCII));
                    version = reader.readLine();
                    Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+).*");
                    Matcher m = pattern.matcher(version);
                    if (m.matches()) {
                        major = Integer.parseInt(m.group(1));
                        minor = Integer.parseInt(m.group(2));
                    }
                    reader.close();
                }
                catch (Throwable err) {
                    LOG.trace("Problem generating fallback version details", err);
                }
            }
        }
        PROVIDER_VERSION = version;
        PROVIDER_MAJOR_VERSION = major;
        PROVIDER_MINOR_VERSION = minor;
    }
}

