/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.jndi;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.jms.JmsQueue;
import org.apache.qpid.jms.JmsTopic;
import org.apache.qpid.jms.jndi.LazyCreateContext;
import org.apache.qpid.jms.jndi.ReadOnlyContext;

public class JmsInitialContextFactory
implements InitialContextFactory {
    static final String[] DEFAULT_CONNECTION_FACTORY_NAMES = new String[]{"ConnectionFactory", "QueueConnectionFactory", "TopicConnectionFactory"};
    static final String DEFAULT_REMOTE_URI = "amqp://localhost:5672";
    static final String CONNECTION_FACTORY_KEY_PREFIX = "connectionfactory.";
    static final String QUEUE_KEY_PREFIX = "queue.";
    static final String TOPIC_KEY_PREFIX = "topic.";
    static final String CONNECTION_FACTORY_DEFAULT_KEY_PREFIX = "default.connectionfactory.";
    static final String CONNECTION_FACTORY_PROPERTY_KEY_PREFIX = "property.connectionfactory.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        Hashtable<Object, Object> environmentCopy;
        block8: {
            environmentCopy = new Hashtable<Object, Object>();
            environmentCopy.putAll(environment);
            String location = null;
            location = environmentCopy.containsKey("java.naming.provider.url") ? (String)environment.get("java.naming.provider.url") : System.getProperty("java.naming.provider.url");
            try {
                BufferedInputStream inputStream;
                if (location == null) break block8;
                try {
                    URL fileURL = new URL(location);
                    inputStream = new BufferedInputStream(fileURL.openStream());
                }
                catch (MalformedURLException e) {
                    inputStream = new BufferedInputStream(new FileInputStream(location));
                }
                Properties p = new Properties();
                try {
                    p.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
                for (Map.Entry<Object, Object> entry : p.entrySet()) {
                    String key = String.valueOf(entry.getKey());
                    String value = String.valueOf(entry.getValue());
                    environmentCopy.put(key, value);
                }
            }
            catch (IOException ioe) {
                NamingException ne = new NamingException("Unable to load property file: " + location + ".");
                ne.initCause(ioe);
                throw ne;
            }
        }
        ConcurrentHashMap<String, Object> bindings = new ConcurrentHashMap<String, Object>();
        this.createConnectionFactories(environmentCopy, bindings);
        this.createQueues(environmentCopy, bindings);
        this.createTopics(environmentCopy, bindings);
        bindings.put("dynamicQueues", new LazyCreateContext(){
            private static final long serialVersionUID = 6503881346214855588L;

            @Override
            protected Object createEntry(String name) {
                return new JmsQueue(name);
            }
        });
        bindings.put("dynamicTopics", new LazyCreateContext(){
            private static final long serialVersionUID = 2019166796234979615L;

            @Override
            protected Object createEntry(String name) {
                return new JmsTopic(name);
            }
        });
        return this.createContext(environmentCopy, bindings);
    }

    private void createConnectionFactories(Hashtable<Object, Object> environment, Map<String, Object> bindings) throws NamingException {
        List<String> names = this.getConnectionFactoryNames(environment);
        Map<String, String> defaults = this.getConnectionFactoryDefaults(environment);
        for (String name : names) {
            JmsConnectionFactory factory = null;
            try {
                factory = this.createConnectionFactory(name, defaults, environment);
            }
            catch (Exception e) {
                NamingException ne = new NamingException("Exception while creating ConnectionFactory '" + name + "'.");
                ne.initCause(e);
                throw ne;
            }
            bindings.put(name, factory);
        }
    }

    protected ReadOnlyContext createContext(Hashtable<Object, Object> environment, Map<String, Object> bindings) {
        return new ReadOnlyContext(environment, bindings);
    }

    protected JmsConnectionFactory createConnectionFactory(String name, Map<String, String> defaults, Hashtable<Object, Object> environment) throws URISyntaxException {
        String value;
        String cfNameKey = CONNECTION_FACTORY_KEY_PREFIX + name;
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.putAll(defaults);
        Object o = environment.get(cfNameKey);
        if (o != null && (value = String.valueOf(o)).trim().length() != 0) {
            props.put("remoteURI", value);
        }
        props.putAll(this.getConnectionFactoryProperties(name, environment));
        return this.createConnectionFactory(props);
    }

    protected List<String> getConnectionFactoryNames(Map<Object, Object> environment) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : environment.entrySet()) {
            String key = String.valueOf(entry.getKey());
            if (!key.startsWith(CONNECTION_FACTORY_KEY_PREFIX)) continue;
            String jndiName = key.substring(CONNECTION_FACTORY_KEY_PREFIX.length());
            list.add(jndiName);
        }
        if (list.isEmpty()) {
            list.addAll(Arrays.asList(DEFAULT_CONNECTION_FACTORY_NAMES));
        }
        return list;
    }

    protected Map<String, String> getConnectionFactoryDefaults(Map<Object, Object> environment) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("remoteURI", DEFAULT_REMOTE_URI);
        for (Map.Entry<Object, Object> entry : environment.entrySet()) {
            String key = String.valueOf(entry.getKey());
            if (!key.startsWith(CONNECTION_FACTORY_DEFAULT_KEY_PREFIX)) continue;
            String jndiName = key.substring(CONNECTION_FACTORY_DEFAULT_KEY_PREFIX.length());
            map.put(jndiName, String.valueOf(entry.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }

    protected Map<String, String> getConnectionFactoryProperties(String factoryName, Map<Object, Object> environment) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String factoryPropertiesPrefix = CONNECTION_FACTORY_PROPERTY_KEY_PREFIX + factoryName + ".";
        for (Map.Entry<Object, Object> entry : environment.entrySet()) {
            String key = String.valueOf(entry.getKey());
            if (!key.startsWith(factoryPropertiesPrefix)) continue;
            String propertyName = key.substring(factoryPropertiesPrefix.length());
            map.put(propertyName, String.valueOf(entry.getValue()));
        }
        return map;
    }

    protected void createQueues(Hashtable<Object, Object> environment, Map<String, Object> bindings) {
        for (Map.Entry<Object, Object> entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(QUEUE_KEY_PREFIX)) continue;
            String jndiName = key.substring(QUEUE_KEY_PREFIX.length());
            bindings.put(jndiName, this.createQueue(entry.getValue().toString()));
        }
    }

    protected void createTopics(Hashtable<Object, Object> environment, Map<String, Object> bindings) {
        for (Map.Entry<Object, Object> entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(TOPIC_KEY_PREFIX)) continue;
            String jndiName = key.substring(TOPIC_KEY_PREFIX.length());
            bindings.put(jndiName, this.createTopic(entry.getValue().toString()));
        }
    }

    protected Queue createQueue(String name) {
        return new JmsQueue(name);
    }

    protected Topic createTopic(String name) {
        return new JmsTopic(name);
    }

    protected JmsConnectionFactory createConnectionFactory(Map<String, String> properties) {
        JmsConnectionFactory factory = new JmsConnectionFactory();
        Map<String, String> unused = factory.setProperties(properties);
        if (!unused.isEmpty()) {
            String msg = " Not all properties could be set on the ConnectionFactory. Check the properties are spelled correctly. Unused properties=[" + unused + "].";
            throw new IllegalArgumentException(msg);
        }
        return factory;
    }
}

