/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider;

import java.io.IOException;
import java.net.URI;
import javax.jms.JMSException;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsMessageFactory;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.meta.JmsTransactionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.ProviderListener;

public class ProviderWrapper<E extends Provider>
implements Provider,
ProviderListener {
    protected final E next;
    protected ProviderListener listener;

    public ProviderWrapper(E next) {
        this.next = next;
        this.next.setProviderListener(this);
    }

    @Override
    public void connect() throws IOException {
        this.next.connect();
    }

    @Override
    public void start() throws IOException, IllegalStateException {
        if (this.listener == null) {
            throw new IllegalStateException("Cannot start with null ProviderListener");
        }
        this.next.start();
    }

    @Override
    public void close() {
        this.next.close();
    }

    @Override
    public URI getRemoteURI() {
        return this.next.getRemoteURI();
    }

    @Override
    public void create(JmsResource resource, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.next.create(resource, request);
    }

    @Override
    public void start(JmsResource resource, AsyncResult request) throws IOException, JMSException {
        this.next.start(resource, request);
    }

    @Override
    public void stop(JmsResource resource, AsyncResult request) throws IOException, JMSException {
        this.next.stop(resource, request);
    }

    @Override
    public void destroy(JmsResource resourceId, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.next.destroy(resourceId, request);
    }

    @Override
    public void send(JmsOutboundMessageDispatch envelope, AsyncResult request) throws IOException, JMSException {
        this.next.send(envelope, request);
    }

    @Override
    public void acknowledge(JmsSessionId sessionId, ProviderConstants.ACK_TYPE ackType, AsyncResult request) throws IOException, JMSException {
        this.next.acknowledge(sessionId, ackType, request);
    }

    @Override
    public void acknowledge(JmsInboundMessageDispatch envelope, ProviderConstants.ACK_TYPE ackType, AsyncResult request) throws IOException, JMSException {
        this.next.acknowledge(envelope, ackType, request);
    }

    @Override
    public void commit(JmsTransactionInfo transactionInfo, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.next.commit(transactionInfo, request);
    }

    @Override
    public void rollback(JmsTransactionInfo transactionInfo, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.next.rollback(transactionInfo, request);
    }

    @Override
    public void recover(JmsSessionId sessionId, AsyncResult request) throws IOException, UnsupportedOperationException {
        this.next.recover(sessionId, request);
    }

    @Override
    public void unsubscribe(String subscription, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.next.unsubscribe(subscription, request);
    }

    @Override
    public void pull(JmsConsumerId consumerId, long timeout, AsyncResult request) throws IOException, UnsupportedOperationException {
        this.next.pull(consumerId, timeout, request);
    }

    @Override
    public JmsMessageFactory getMessageFactory() {
        return this.next.getMessageFactory();
    }

    @Override
    public void setProviderListener(ProviderListener listener) {
        this.listener = listener;
    }

    @Override
    public ProviderListener getProviderListener() {
        return this.listener;
    }

    @Override
    public void onInboundMessage(JmsInboundMessageDispatch envelope) {
        this.listener.onInboundMessage(envelope);
    }

    @Override
    public void onConnectionInterrupted(URI remoteURI) {
        this.listener.onConnectionInterrupted(remoteURI);
    }

    @Override
    public void onConnectionRecovery(Provider provider) throws Exception {
        this.listener.onConnectionRecovery(provider);
    }

    @Override
    public void onConnectionRecovered(Provider provider) throws Exception {
        this.listener.onConnectionRecovered(provider);
    }

    @Override
    public void onConnectionRestored(URI remoteURI) {
        this.listener.onConnectionRestored(remoteURI);
    }

    @Override
    public void onConnectionEstablished(URI remoteURI) {
        this.listener.onConnectionEstablished(this.next.getRemoteURI());
    }

    @Override
    public void onConnectionFailure(IOException ex) {
        this.listener.onConnectionFailure(ex);
    }

    @Override
    public void onResourceRemotelyClosed(JmsResource resource, Exception cause) {
        this.listener.onResourceRemotelyClosed(resource, cause);
    }

    @Override
    public void onProviderException(Exception cause) {
        this.listener.onProviderException(cause);
    }

    public Provider getNext() {
        return this.next;
    }
}

