/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.jms.util.InetAddressUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdGenerator {
    private static final Logger LOG;
    private static String hostName;
    private final String prefix;
    private final AtomicLong sequence = new AtomicLong(1L);
    public static final String PROPERTY_IDGENERATOR_HOST_PREFIX = "qpidjms.idgenerator.hostPrefixEnabled";

    public IdGenerator(String prefix) {
        this.prefix = prefix + (hostName != null ? hostName : "") + ":";
    }

    public IdGenerator() {
        this("ID:");
    }

    public String generateId() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.prefix);
        sb.append(UUID.randomUUID());
        sb.append(":");
        sb.append(this.sequence.getAndIncrement());
        return sb.toString();
    }

    protected static String sanitizeHostName(String hostName) {
        boolean changed = false;
        StringBuilder sb = new StringBuilder();
        for (char ch : hostName.toCharArray()) {
            if (ch < '\u007f') {
                sb.append(ch);
                continue;
            }
            changed = true;
        }
        if (changed) {
            String newHost = sb.toString();
            LOG.info("Sanitized hostname from: {} to: {}", (Object)hostName, (Object)newHost);
            return newHost;
        }
        return hostName;
    }

    static {
        boolean addHostPrefix;
        LOG = LoggerFactory.getLogger(IdGenerator.class);
        boolean canAccessSystemProps = true;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPropertiesAccess();
            }
        }
        catch (SecurityException se) {
            canAccessSystemProps = false;
        }
        if (canAccessSystemProps && (addHostPrefix = Boolean.getBoolean(PROPERTY_IDGENERATOR_HOST_PREFIX))) {
            block9: {
                try {
                    LOG.trace("ID Generator attemtping to lookup host name prefix.");
                    hostName = InetAddressUtil.getLocalHostName();
                }
                catch (Exception e) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("could not generate host name prefix from DNS lookup.", (Throwable)e);
                    } else {
                        LOG.warn("could not generate host name prefix from DNS lookup: {} {}", (Object)e.getClass().getCanonicalName(), (Object)e.getMessage());
                    }
                    if (!(e instanceof InterruptedException)) break block9;
                    Thread.currentThread().interrupt();
                }
            }
            if (hostName == null) {
                hostName = "localhost";
            }
            hostName = IdGenerator.sanitizeHostName(hostName);
        }
    }
}

