/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.failover;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.apache.qpid.jms.JmsOperationTimedOutException;
import org.apache.qpid.jms.JmsSendTimedOutException;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsMessageFactory;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.meta.JmsTransactionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.DefaultProviderListener;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.ProviderFactory;
import org.apache.qpid.jms.provider.ProviderFuture;
import org.apache.qpid.jms.provider.ProviderListener;
import org.apache.qpid.jms.provider.ProviderRedirectedException;
import org.apache.qpid.jms.provider.WrappedAsyncResult;
import org.apache.qpid.jms.provider.failover.FailoverUriPool;
import org.apache.qpid.jms.util.IOExceptionSupport;
import org.apache.qpid.jms.util.ThreadPoolUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverProvider
extends DefaultProviderListener
implements Provider {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverProvider.class);
    public static final int UNLIMITED = -1;
    private static final int UNDEFINED = -1;
    private static final int DISABLED = 0;
    private static final int MINIMUM_TIMEOUT = 1000;
    public static final int DEFAULT_MAX_RECONNECT_ATTEMPTS = -1;
    public static final int DEFAULT_STARTUP_MAX_RECONNECT_ATTEMPTS = -1;
    public static final long DEFAULT_INITIAL_RECONNECT_DELAY = 0L;
    public static final long DEFAULT_RECONNECT_DELAY = 10L;
    public static final long DEFAULT_MAX_RECONNECT_DELAY = TimeUnit.SECONDS.toMillis(30L);
    public static final boolean DEFAULT_USE_RECONNECT_BACKOFF = true;
    public static final double DEFAULT_RECONNECT_BACKOFF_MULTIPLIER = 2.0;
    public static final int DEFAULT_WARN_AFTER_RECONNECT_ATTEMPTS = 10;
    private ProviderListener listener;
    private Provider provider;
    private final FailoverUriPool uris;
    private ScheduledFuture<?> requestTimeoutTask;
    private final ScheduledExecutorService serializer;
    private final ScheduledExecutorService connectionHub;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean failed = new AtomicBoolean();
    private final AtomicBoolean closingConnection = new AtomicBoolean(false);
    private final AtomicLong requestId = new AtomicLong();
    private final Map<Long, FailoverRequest> requests = new LinkedHashMap<Long, FailoverRequest>();
    private final DefaultProviderListener closedListener = new DefaultProviderListener();
    private final AtomicReference<JmsMessageFactory> messageFactory = new AtomicReference();
    private boolean firstAttempt = true;
    private boolean firstConnection = true;
    private long reconnectAttempts;
    private long nextReconnectDelay = -1L;
    private IOException failureCause;
    private URI connectedURI;
    private long closeTimeout = 15000L;
    private long sendTimeout = -1L;
    private long requestTimeout = -1L;
    private long initialReconnectDelay = 0L;
    private long reconnectDelay = 10L;
    private long maxReconnectDelay = DEFAULT_MAX_RECONNECT_DELAY;
    private boolean useReconnectBackOff = true;
    private double reconnectBackOffMultiplier = 2.0;
    private int maxReconnectAttempts = -1;
    private int startupMaxReconnectAttempts = -1;
    private int warnAfterReconnectAttempts = 10;

    public FailoverProvider(Map<String, String> nestedOptions) {
        this(null, nestedOptions);
    }

    public FailoverProvider(List<URI> uris) {
        this(uris, null);
    }

    public FailoverProvider(List<URI> uris, Map<String, String> nestedOptions) {
        this.uris = new FailoverUriPool(uris, nestedOptions);
        this.serializer = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runner) {
                Thread serial = new Thread(runner);
                serial.setDaemon(true);
                serial.setName("FailoverProvider: serialization thread");
                return serial;
            }
        });
        this.connectionHub = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runner) {
                Thread serial = new Thread(runner);
                serial.setDaemon(true);
                serial.setName("FailoverProvider: connect thread");
                return serial;
            }
        });
    }

    @Override
    public void connect() throws IOException {
        this.checkClosed();
        LOG.debug("Initiating initial connection attempt task");
        this.triggerReconnectionAttempt();
    }

    @Override
    public void start() throws IOException, IllegalStateException {
        this.checkClosed();
        if (this.listener == null) {
            throw new IllegalStateException("No ProviderListener registered.");
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            final ProviderFuture request = new ProviderFuture();
            this.serializer.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        IOException error = FailoverProvider.this.failureCause != null ? FailoverProvider.this.failureCause : new IOException("Connection closed");
                        ArrayList pending = new ArrayList(FailoverProvider.this.requests.values());
                        for (FailoverRequest request2 : pending) {
                            request2.onFailure(error);
                        }
                        if (FailoverProvider.this.requestTimeoutTask != null) {
                            FailoverProvider.this.requestTimeoutTask.cancel(false);
                        }
                        if (FailoverProvider.this.provider != null) {
                            FailoverProvider.this.provider.close();
                        }
                    }
                    catch (Exception e) {
                        LOG.debug("Caught exception while closing connection");
                    }
                    finally {
                        ThreadPoolUtils.shutdownGraceful(FailoverProvider.this.connectionHub);
                        if (FailoverProvider.this.serializer != null) {
                            FailoverProvider.this.serializer.shutdown();
                        }
                        request.onSuccess();
                    }
                }
            });
            try {
                if (this.closeTimeout < 0L) {
                    request.sync();
                } else {
                    request.sync(Math.max(1000L, this.closeTimeout), TimeUnit.MILLISECONDS);
                }
            }
            catch (IOException e) {
                LOG.warn("Error caught while closing Provider: ", (Object)e.getMessage());
            }
        }
    }

    @Override
    public void create(final JmsResource resource, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = null;
        pending = resource instanceof JmsConnectionInfo ? new CreateConnectionRequest(request){

            @Override
            public void doTask() throws Exception {
                JmsConnectionInfo connectionInfo = (JmsConnectionInfo)resource;
                FailoverProvider.this.closeTimeout = connectionInfo.getCloseTimeout();
                FailoverProvider.this.sendTimeout = connectionInfo.getSendTimeout();
                FailoverProvider.this.requestTimeout = connectionInfo.getRequestTimeout();
                FailoverProvider.this.provider.create(resource, this);
            }

            public String toString() {
                return "create -> " + resource;
            }
        } : new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.create(resource, this);
            }

            @Override
            public boolean succeedsWhenOffline() {
                if (resource instanceof JmsTransactionInfo) {
                    JmsTransactionInfo transactionInfo = (JmsTransactionInfo)resource;
                    transactionInfo.setInDoubt(true);
                    return true;
                }
                return false;
            }

            public String toString() {
                return "create -> " + resource;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void start(final JmsResource resource, AsyncResult request) throws IOException, JMSException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.start(resource, this);
            }

            public String toString() {
                return "start -> " + resource;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void stop(final JmsResource resource, AsyncResult request) throws IOException, JMSException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.stop(resource, this);
            }

            public String toString() {
                return "stop -> " + resource;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void destroy(final JmsResource resourceId, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws IOException, JMSException, UnsupportedOperationException {
                if (resourceId instanceof JmsConnectionInfo) {
                    FailoverProvider.this.closingConnection.set(true);
                }
                FailoverProvider.this.provider.destroy(resourceId, this);
            }

            @Override
            public boolean succeedsWhenOffline() {
                return true;
            }

            public String toString() {
                return "destroy -> " + resourceId;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void send(final JmsOutboundMessageDispatch envelope, AsyncResult request) throws IOException, JMSException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.sendTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.send(envelope, this);
            }

            public String toString() {
                return "send -> " + envelope;
            }

            @Override
            public JMSException createTimedOutException() {
                return new JmsSendTimedOutException("Timed out waiting on " + this, envelope.getMessage());
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void acknowledge(final JmsSessionId sessionId, final ProviderConstants.ACK_TYPE ackType, AsyncResult request) throws IOException, JMSException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.acknowledge(sessionId, ackType, (AsyncResult)this);
            }

            @Override
            public boolean succeedsWhenOffline() {
                return true;
            }

            public String toString() {
                return "session acknowledge -> " + sessionId;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void acknowledge(final JmsInboundMessageDispatch envelope, final ProviderConstants.ACK_TYPE ackType, AsyncResult request) throws IOException, JMSException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.acknowledge(envelope, ackType, (AsyncResult)this);
            }

            @Override
            public boolean succeedsWhenOffline() {
                return true;
            }

            public String toString() {
                return "message acknowledge -> " + envelope + " ackType: " + (Object)((Object)ackType);
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void commit(final JmsTransactionInfo transactionInfo, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.commit(transactionInfo, this);
            }

            @Override
            public boolean failureWhenOffline() {
                return true;
            }

            public String toString() {
                return "TX commit -> " + transactionInfo.getId();
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void rollback(final JmsTransactionInfo transactionInfo, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.rollback(transactionInfo, this);
            }

            @Override
            public boolean succeedsWhenOffline() {
                return true;
            }

            public String toString() {
                return "TX rollback -> " + transactionInfo.getId();
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void recover(final JmsSessionId sessionId, AsyncResult request) throws IOException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.recover(sessionId, this);
            }

            @Override
            public boolean succeedsWhenOffline() {
                return true;
            }

            public String toString() {
                return "recover -> " + sessionId;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void unsubscribe(final String subscription, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request, this.requestTimeout){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.unsubscribe(subscription, this);
            }

            public String toString() {
                return "unsubscribe -> " + subscription;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void pull(final JmsConsumerId consumerId, final long timeout, AsyncResult request) throws IOException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.pull(consumerId, timeout, this);
            }

            public String toString() {
                return "message pull -> " + consumerId;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public JmsMessageFactory getMessageFactory() {
        return this.messageFactory.get();
    }

    private void handleProviderFailure(IOException cause) {
        LOG.debug("handling Provider failure: {}", (Object)cause.getMessage());
        LOG.trace("stack", (Throwable)cause);
        this.provider.setProviderListener(this.closedListener);
        URI failedURI = this.provider.getRemoteURI();
        try {
            this.provider.close();
        }
        catch (Throwable error) {
            LOG.trace("Caught exception while closing failed provider: {}", (Object)error.getMessage());
        }
        this.provider = null;
        if (this.reconnectAllowed(cause)) {
            long sweeperInterval;
            ProviderListener listener;
            if (cause instanceof ProviderRedirectedException) {
                ProviderRedirectedException redirect = (ProviderRedirectedException)cause;
                try {
                    this.uris.addFirst(new URI(failedURI.getScheme() + "://" + redirect.getNetworkHost() + ":" + redirect.getPort()));
                }
                catch (URISyntaxException ex) {
                    LOG.warn("Could not construct redirection URI from remote provided information");
                }
            }
            if ((listener = this.listener) != null) {
                listener.onConnectionInterrupted(failedURI);
            }
            if (this.requestTimeoutTask == null && (sweeperInterval = this.getRequestSweeperInterval()) > 0L) {
                LOG.trace("Request timeout monitoring enabled: interval = {}ms", (Object)sweeperInterval);
                this.requestTimeoutTask = this.serializer.scheduleWithFixedDelay(new FailoverRequestSweeper(), sweeperInterval, sweeperInterval, TimeUnit.MILLISECONDS);
            }
            this.triggerReconnectionAttempt();
        } else {
            ProviderListener listener = this.listener;
            if (listener != null) {
                listener.onConnectionFailure(cause);
            }
        }
    }

    private void initializeNewConnection(final Provider provider) {
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    FailoverProvider.this.provider = provider;
                    provider.setProviderListener(FailoverProvider.this);
                    if (!FailoverProvider.this.firstConnection) {
                        LOG.debug("Signalling connection recovery: {}", (Object)provider);
                        FailoverProvider.this.listener.onConnectionRecovery(provider);
                        FailoverProvider.this.messageFactory.set(provider.getMessageFactory());
                        FailoverProvider.this.listener.onConnectionRecovered(provider);
                        FailoverProvider.this.listener.onConnectionRestored(provider.getRemoteURI());
                    }
                    ArrayList pending = new ArrayList(FailoverProvider.this.requests.values());
                    for (FailoverRequest request : pending) {
                        request.run();
                    }
                    FailoverProvider.this.nextReconnectDelay = FailoverProvider.this.reconnectDelay;
                    FailoverProvider.this.reconnectAttempts = 0L;
                    FailoverProvider.this.connectedURI = provider.getRemoteURI();
                    FailoverProvider.this.uris.connected();
                    if (FailoverProvider.this.requestTimeoutTask != null) {
                        FailoverProvider.this.requestTimeoutTask.cancel(false);
                        FailoverProvider.this.requestTimeoutTask = null;
                    }
                }
                catch (Throwable error) {
                    FailoverProvider.this.handleProviderFailure(IOExceptionSupport.create(error));
                }
            }
        });
    }

    private void triggerReconnectionAttempt() {
        if (this.closingConnection.get() || this.closed.get() || this.failed.get()) {
            return;
        }
        this.connectionHub.execute(new Runnable(){
            boolean delayed = false;

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                if (FailoverProvider.access$300(FailoverProvider.this) != null || FailoverProvider.access$1000(FailoverProvider.this).get() || FailoverProvider.access$2000(FailoverProvider.this).get() || FailoverProvider.access$2100(FailoverProvider.this).get()) {
                    return;
                }
                reconnectLimit = FailoverProvider.access$2200(FailoverProvider.this);
                if (reconnectLimit != -1 && FailoverProvider.access$1600(FailoverProvider.this) >= (long)reconnectLimit) {
                    return;
                }
                first = FailoverProvider.access$2300(FailoverProvider.this);
                FailoverProvider.access$2302(FailoverProvider.this, false);
                if (!this.delayed && !first && FailoverProvider.access$2400(FailoverProvider.this) > 0L && FailoverProvider.access$1600(FailoverProvider.this) == 0L) {
                    this.delayed = true;
                    FailoverProvider.access$400().trace("Delayed initial reconnect attempt will be in {} milliseconds", (Object)FailoverProvider.access$2400(FailoverProvider.this));
                    FailoverProvider.access$500(FailoverProvider.this).schedule(this, FailoverProvider.access$2400(FailoverProvider.this), TimeUnit.MILLISECONDS);
                    return;
                }
                FailoverProvider.access$1608(FailoverProvider.this);
                failure = null;
                target = FailoverProvider.access$1800(FailoverProvider.this).getNext();
                if (target != null) {
                    provider = null;
                    try {
                        FailoverProvider.access$400().debug("Connection attempt:[{}] to: {} in-progress", (Object)FailoverProvider.access$1600(FailoverProvider.this), (Object)target);
                        provider = ProviderFactory.create(target);
                        provider.connect();
                        FailoverProvider.access$2500(FailoverProvider.this, provider);
                        return;
                    }
                    catch (Throwable e) {
                        FailoverProvider.access$400().info("Connection attempt:[{}] to: {} failed", (Object)FailoverProvider.access$1600(FailoverProvider.this), (Object)target);
                        failure = e;
                        try {
                            if (provider == null) ** GOTO lbl37
                            provider.close();
                        }
                        catch (Throwable ex) {}
                    }
                } else {
                    FailoverProvider.access$400().debug("No target URI available to connect to");
                }
lbl37:
                // 4 sources

                if (reconnectLimit != -1 && FailoverProvider.access$1600(FailoverProvider.this) >= (long)reconnectLimit) {
                    FailoverProvider.access$400().error("Failed to connect after: " + FailoverProvider.access$1600(FailoverProvider.this) + " attempt(s)");
                    FailoverProvider.access$2100(FailoverProvider.this).set(true);
                    if (failure == null) {
                        FailoverProvider.access$002(FailoverProvider.this, new IOException("Failed to connect after: " + FailoverProvider.access$1600(FailoverProvider.this) + " attempt(s)"));
                    } else {
                        FailoverProvider.access$002(FailoverProvider.this, IOExceptionSupport.create(failure));
                    }
                    if (FailoverProvider.access$1200(FailoverProvider.this) != null) {
                        FailoverProvider.access$1200(FailoverProvider.this).onConnectionFailure(FailoverProvider.access$000(FailoverProvider.this));
                    }
                    return;
                }
                warnInterval = FailoverProvider.this.getWarnAfterReconnectAttempts();
                if (warnInterval > 0 && FailoverProvider.access$1600(FailoverProvider.this) % (long)warnInterval == 0L) {
                    FailoverProvider.access$400().warn("Failed to connect after: {} attempt(s) continuing to retry.", (Object)FailoverProvider.access$1600(FailoverProvider.this));
                }
                delay = FailoverProvider.access$2600(FailoverProvider.this);
                FailoverProvider.access$400().trace("Next reconnect attempt will be in {} milliseconds", (Object)delay);
                FailoverProvider.access$500(FailoverProvider.this).schedule(this, delay, TimeUnit.MILLISECONDS);
            }
        });
    }

    private boolean reconnectAllowed(IOException cause) {
        if (cause.getCause() instanceof JMSSecurityException) {
            return false;
        }
        return this.reconnectAttemptLimit() != 0;
    }

    private int reconnectAttemptLimit() {
        int maxReconnectValue = this.maxReconnectAttempts;
        if (this.firstConnection && this.startupMaxReconnectAttempts != -1) {
            maxReconnectValue = this.startupMaxReconnectAttempts;
        }
        return maxReconnectValue;
    }

    private long nextReconnectDelay() {
        if (this.nextReconnectDelay == -1L) {
            this.nextReconnectDelay = this.reconnectDelay;
        }
        if (this.isUseReconnectBackOff() && this.reconnectAttempts > 1L) {
            this.nextReconnectDelay = (long)((double)this.nextReconnectDelay * this.getReconnectBackOffMultiplier());
            if (this.nextReconnectDelay > this.maxReconnectDelay) {
                this.nextReconnectDelay = this.maxReconnectDelay;
            }
        }
        return this.nextReconnectDelay;
    }

    protected void checkClosed() throws IOException {
        if (this.closed.get()) {
            throw new IOException("The Provider is already closed");
        }
    }

    @Override
    public void onInboundMessage(JmsInboundMessageDispatch envelope) {
        if (this.closingConnection.get() || this.closed.get() || this.failed.get()) {
            return;
        }
        this.listener.onInboundMessage(envelope);
    }

    @Override
    public void onConnectionFailure(final IOException ex) {
        if (this.closingConnection.get() || this.closed.get() || this.failed.get()) {
            return;
        }
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                if (!(FailoverProvider.this.closingConnection.get() || FailoverProvider.this.closed.get() || FailoverProvider.this.failed.get())) {
                    LOG.debug("Failover: the provider reports failure: {}", (Object)ex.getMessage());
                    FailoverProvider.this.handleProviderFailure(ex);
                }
            }
        });
    }

    @Override
    public void onProviderException(final Exception ex) {
        if (this.closingConnection.get() || this.closed.get() || this.failed.get()) {
            return;
        }
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                if (!(FailoverProvider.this.closingConnection.get() || FailoverProvider.this.closed.get() || FailoverProvider.this.failed.get())) {
                    LOG.debug("Failover: the provider reports an async error: {}", (Object)ex.getMessage());
                    FailoverProvider.this.listener.onProviderException(ex);
                }
            }
        });
    }

    public void add(final URI uri) {
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                FailoverProvider.this.uris.add(uri);
            }
        });
    }

    public void remove(final URI uri) {
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                FailoverProvider.this.uris.remove(uri);
            }
        });
    }

    @Override
    public URI getRemoteURI() {
        Provider provider = this.provider;
        if (provider != null) {
            return provider.getRemoteURI();
        }
        return null;
    }

    @Override
    public void setProviderListener(ProviderListener listener) {
        this.listener = listener;
    }

    @Override
    public ProviderListener getProviderListener() {
        return this.listener;
    }

    public boolean isRandomize() {
        return this.uris.isRandomize();
    }

    public void setRandomize(boolean value) {
        this.uris.setRandomize(value);
    }

    public long getInitialReconnectDelay() {
        return this.initialReconnectDelay;
    }

    public void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDealy) {
        this.reconnectDelay = reconnectDealy;
    }

    public long getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public int getStartupMaxReconnectAttempts() {
        return this.startupMaxReconnectAttempts;
    }

    public void setStartupMaxReconnectAttempts(int startupMaxReconnectAttempts) {
        this.startupMaxReconnectAttempts = startupMaxReconnectAttempts;
    }

    public int getWarnAfterReconnectAttempts() {
        return this.warnAfterReconnectAttempts;
    }

    public void setWarnAfterReconnectAttempts(int warnAfterReconnectAttempts) {
        this.warnAfterReconnectAttempts = warnAfterReconnectAttempts;
    }

    public double getReconnectBackOffMultiplier() {
        return this.reconnectBackOffMultiplier;
    }

    public void setReconnectBackOffMultiplier(double reconnectBackOffMultiplier) {
        this.reconnectBackOffMultiplier = reconnectBackOffMultiplier;
    }

    public boolean isUseReconnectBackOff() {
        return this.useReconnectBackOff;
    }

    public void setUseReconnectBackOff(boolean useReconnectBackOff) {
        this.useReconnectBackOff = useReconnectBackOff;
    }

    public long getCloseTimeout() {
        return this.closeTimeout;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public Map<String, String> getNestedOptions() {
        return this.uris.getNestedOptions();
    }

    public String toString() {
        return "FailoverProvider: " + (this.connectedURI == null ? "unconnected" : this.connectedURI.toString());
    }

    protected final long getRequestSweeperInterval() {
        long[] timeouts = new long[]{this.requestTimeout, this.sendTimeout};
        Arrays.sort(timeouts);
        for (long timeout : timeouts) {
            if (timeout == -1L) continue;
            return Math.max(Math.max(1L, timeout) / 3L, 1000L);
        }
        return 0L;
    }

    static /* synthetic */ int access$2200(FailoverProvider x0) {
        return x0.reconnectAttemptLimit();
    }

    static /* synthetic */ long access$1600(FailoverProvider x0) {
        return x0.reconnectAttempts;
    }

    static /* synthetic */ boolean access$2300(FailoverProvider x0) {
        return x0.firstAttempt;
    }

    static /* synthetic */ boolean access$2302(FailoverProvider x0, boolean x1) {
        x0.firstAttempt = x1;
        return x0.firstAttempt;
    }

    static /* synthetic */ long access$2400(FailoverProvider x0) {
        return x0.initialReconnectDelay;
    }

    static /* synthetic */ long access$1608(FailoverProvider x0) {
        return x0.reconnectAttempts++;
    }

    static /* synthetic */ void access$2500(FailoverProvider x0, Provider x1) {
        x0.initializeNewConnection(x1);
    }

    static /* synthetic */ IOException access$002(FailoverProvider x0, IOException x1) {
        x0.failureCause = x1;
        return x0.failureCause;
    }

    static /* synthetic */ long access$2600(FailoverProvider x0) {
        return x0.nextReconnectDelay();
    }

    protected abstract class CreateConnectionRequest
    extends FailoverRequest {
        public CreateConnectionRequest(AsyncResult watcher) {
            super(watcher);
        }

        @Override
        public void onSuccess() {
            FailoverProvider.this.serializer.execute(new Runnable(){

                @Override
                public void run() {
                    if (FailoverProvider.this.firstConnection) {
                        LOG.trace("First connection requst has completed:");
                        FailoverProvider.this.messageFactory.set(FailoverProvider.this.provider.getMessageFactory());
                        FailoverProvider.this.listener.onConnectionEstablished(FailoverProvider.this.provider.getRemoteURI());
                        FailoverProvider.this.firstConnection = false;
                    } else {
                        LOG.warn("A second call to a CreateConnectionRequest not expected.");
                    }
                    CreateConnectionRequest.this.signalConnected();
                }
            });
        }

        @Override
        public void onFailure(final Throwable result) {
            if (FailoverProvider.this.closingConnection.get() || FailoverProvider.this.closed.get() || FailoverProvider.this.failed.get()) {
                FailoverProvider.this.requests.remove(this.id);
                super.onFailure(result);
            } else {
                LOG.debug("Request received error: {}", (Object)result.getMessage());
                FailoverProvider.this.serializer.execute(new Runnable(){

                    @Override
                    public void run() {
                        FailoverProvider.this.handleProviderFailure(IOExceptionSupport.create(result));
                    }
                });
            }
        }

        public void signalConnected() {
            super.onSuccess();
        }
    }

    protected abstract class FailoverRequest
    extends WrappedAsyncResult
    implements Runnable {
        protected final long id;
        private final long requestStarted;
        private final long requestTimeout;

        public FailoverRequest(AsyncResult watcher) {
            this(watcher, -1L);
        }

        public FailoverRequest(AsyncResult watcher, long requestTimeout) {
            super(watcher);
            this.id = FailoverProvider.this.requestId.incrementAndGet();
            this.requestStarted = System.nanoTime();
            this.requestTimeout = requestTimeout;
            LOG.trace("Created Failover Task: {} ({})", (Object)this, (Object)this.id);
        }

        @Override
        public void run() {
            FailoverProvider.this.requests.put(this.id, this);
            if (FailoverProvider.this.provider == null) {
                this.whenOffline(new IOException("Connection failed."));
            } else {
                try {
                    LOG.debug("Executing Failover Task: {} ({})", (Object)this, (Object)this.id);
                    this.doTask();
                }
                catch (UnsupportedOperationException e) {
                    FailoverProvider.this.requests.remove(this.id);
                    this.getWrappedRequest().onFailure(e);
                }
                catch (JMSException jmsEx) {
                    FailoverProvider.this.requests.remove(this.id);
                    this.getWrappedRequest().onFailure(jmsEx);
                }
                catch (Throwable e) {
                    LOG.debug("Caught exception while executing task: {} - {}", (Object)this, (Object)e.getMessage());
                    this.whenOffline(IOExceptionSupport.create(e));
                    FailoverProvider.this.handleProviderFailure(IOExceptionSupport.create(e));
                }
            }
        }

        @Override
        public void onFailure(final Throwable result) {
            if (result instanceof JMSException || FailoverProvider.this.closingConnection.get() || FailoverProvider.this.closed.get() || FailoverProvider.this.failed.get()) {
                FailoverProvider.this.requests.remove(this.id);
                super.onFailure(result);
            } else {
                LOG.debug("Request received error: {}", (Object)result.getMessage());
                FailoverProvider.this.serializer.execute(new Runnable(){

                    @Override
                    public void run() {
                        FailoverProvider.this.handleProviderFailure(IOExceptionSupport.create(result));
                    }
                });
            }
        }

        @Override
        public void onSuccess() {
            FailoverProvider.this.requests.remove(this.id);
            super.onSuccess();
        }

        public abstract void doTask() throws Exception;

        public boolean succeedsWhenOffline() {
            return false;
        }

        public boolean failureWhenOffline() {
            return false;
        }

        public boolean isExpired() {
            if (this.requestTimeout != -1L) {
                return System.nanoTime() - this.requestStarted > TimeUnit.MILLISECONDS.toNanos(this.requestTimeout);
            }
            return false;
        }

        public JMSException createTimedOutException() {
            return new JmsOperationTimedOutException("Timed out waiting on " + this);
        }

        private void whenOffline(IOException error) {
            if (this.failureWhenOffline()) {
                FailoverProvider.this.requests.remove(this.id);
                this.getWrappedRequest().onFailure(IOExceptionSupport.create(error));
            } else if (this.succeedsWhenOffline()) {
                this.onSuccess();
            } else {
                LOG.trace("Failover task held until connection recovered: {} ({})", (Object)this, (Object)this.id);
            }
        }
    }

    protected final class FailoverRequestSweeper
    implements Runnable {
        protected FailoverRequestSweeper() {
        }

        @Override
        public void run() {
            ArrayList copied = new ArrayList(FailoverProvider.this.requests.values());
            for (FailoverRequest request : copied) {
                if (!request.isExpired()) continue;
                LOG.trace("Task {} has timed out, sending failure notice.", (Object)request);
                request.onFailure(request.createTimedOutException());
            }
        }
    }
}

