/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public class CompositeWritableBuffer
implements WritableBuffer {
    private final WritableBuffer _first;
    private final WritableBuffer _second;

    public CompositeWritableBuffer(WritableBuffer first, WritableBuffer second) {
        this._first = first;
        this._second = second;
    }

    @Override
    public void put(byte b) {
        (this._first.hasRemaining() ? this._first : this._second).put(b);
    }

    @Override
    public void putFloat(float f) {
        this.putInt(Float.floatToRawIntBits(f));
    }

    @Override
    public void putDouble(double d) {
        this.putLong(Double.doubleToRawLongBits(d));
    }

    @Override
    public void put(byte[] src, int offset, int length) {
        int remaining = this._first.remaining();
        if (length > remaining) {
            if (remaining == 0) {
                this._second.put(src, offset, length);
            } else {
                this._first.put(src, offset, remaining);
                this._second.put(src, offset + remaining, length - remaining);
            }
        } else {
            this._first.put(src, offset, length);
        }
    }

    @Override
    public void putShort(short s) {
        switch (this._first.remaining()) {
            case 0: {
                this._second.putShort(s);
                break;
            }
            case 1: {
                this._first.put((byte)(s >>> 8));
                this._second.put((byte)s);
                break;
            }
            default: {
                this._first.putShort(s);
            }
        }
    }

    @Override
    public void putInt(int i) {
        if (this._first.remaining() >= 4) {
            this._first.putInt(i);
        } else {
            int j;
            for (j = 3; this._first.hasRemaining() && j != 0; --j) {
                this._first.put((byte)(i >>> 8 * j));
            }
            while (j != 0) {
                this._second.put((byte)(i >>> 8 * j));
            }
        }
    }

    @Override
    public void putLong(long l) {
        if (this._first.remaining() >= 8) {
            this._first.putLong(l);
        } else {
            int j;
            for (j = 7; this._first.hasRemaining() && j != 0; --j) {
                this._first.put((byte)(l >>> 8 * j));
            }
            while (j != 0) {
                this._second.put((byte)(l >>> 8 * j));
            }
        }
    }

    @Override
    public boolean hasRemaining() {
        return this._first.hasRemaining() || this._second.hasRemaining();
    }

    @Override
    public int remaining() {
        return this._first.remaining() + this._second.remaining();
    }

    @Override
    public int position() {
        return this._first.position() + this._second.position();
    }

    @Override
    public void position(int position) {
        int currentPosition = this.position();
        if (position > currentPosition) {
            int relativePosition = position - currentPosition;
            if (this._first.hasRemaining()) {
                int firstRemaining = this._first.remaining();
                if (relativePosition > firstRemaining) {
                    this._first.position(this._first.position() + firstRemaining);
                    relativePosition -= firstRemaining;
                } else {
                    this._first.position(this._first.position() + relativePosition);
                    return;
                }
            }
            this._second.position(this._second.position() + relativePosition);
        } else if (position < currentPosition) {
            if (this._first.hasRemaining()) {
                this._first.position(position);
            } else {
                int relativePosition = currentPosition - position;
                if (relativePosition <= this._second.position()) {
                    this._second.position(this._second.position() - relativePosition);
                } else {
                    this._second.position(0);
                    this._first.position(this._first.position() - (relativePosition -= this._second.position()));
                }
            }
        }
    }

    @Override
    public void put(ByteBuffer payload) {
        if (this._first.hasRemaining()) {
            if (this._first.remaining() >= payload.remaining()) {
                this._first.put(payload);
            } else {
                int limit = payload.limit();
                payload.limit(payload.position() + this._first.remaining());
                this._first.put(payload);
                payload.limit(limit);
                this._second.put(payload);
            }
        } else {
            this._second.put(payload);
        }
    }
}

