/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Collection;
import java.util.Collections;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FixedSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;
import org.apache.qpid.proton.type.Decimal32;

public class Decimal32Type
extends AbstractPrimitiveType<Decimal32> {
    private Decimal32Encoding _decimal32Encoder;

    Decimal32Type(EncoderImpl encoder, DecoderImpl decoder) {
        this._decimal32Encoder = new Decimal32Encoding(encoder, decoder);
        encoder.register(Decimal32.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Decimal32> getTypeClass() {
        return Decimal32.class;
    }

    public Decimal32Encoding getEncoding(Decimal32 val) {
        return this._decimal32Encoder;
    }

    public Decimal32Encoding getCanonicalEncoding() {
        return this._decimal32Encoder;
    }

    @Override
    public Collection<Decimal32Encoding> getAllEncodings() {
        return Collections.singleton(this._decimal32Encoder);
    }

    private class Decimal32Encoding
    extends FixedSizePrimitiveTypeEncoding<Decimal32> {
        public Decimal32Encoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected int getFixedSize() {
            return 4;
        }

        @Override
        public byte getEncodingCode() {
            return 116;
        }

        public Decimal32Type getType() {
            return Decimal32Type.this;
        }

        @Override
        public void writeValue(Decimal32 val) {
            this.getEncoder().writeRaw(val.getBits());
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Decimal32> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Decimal32 readValue() {
            return new Decimal32(this.getDecoder().readRawInt());
        }
    }
}

