/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Collection;
import java.util.Collections;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FixedSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;
import org.apache.qpid.proton.type.Decimal64;

public class Decimal64Type
extends AbstractPrimitiveType<Decimal64> {
    private Decimal64Encoding _decimal64Encoder;

    Decimal64Type(EncoderImpl encoder, DecoderImpl decoder) {
        this._decimal64Encoder = new Decimal64Encoding(encoder, decoder);
        encoder.register(Decimal64.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Decimal64> getTypeClass() {
        return Decimal64.class;
    }

    public Decimal64Encoding getEncoding(Decimal64 val) {
        return this._decimal64Encoder;
    }

    public Decimal64Encoding getCanonicalEncoding() {
        return this._decimal64Encoder;
    }

    @Override
    public Collection<Decimal64Encoding> getAllEncodings() {
        return Collections.singleton(this._decimal64Encoder);
    }

    private class Decimal64Encoding
    extends FixedSizePrimitiveTypeEncoding<Decimal64> {
        public Decimal64Encoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected int getFixedSize() {
            return 8;
        }

        @Override
        public byte getEncodingCode() {
            return -124;
        }

        public Decimal64Type getType() {
            return Decimal64Type.this;
        }

        @Override
        public void writeValue(Decimal64 val) {
            this.getEncoder().writeRaw(val.getBits());
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Decimal64> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Decimal64 readValue() {
            return new Decimal64(this.getDecoder().readRawLong());
        }
    }
}

