/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.driver.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.driver.Connector;
import org.apache.qpid.proton.driver.Listener;
import org.apache.qpid.proton.driver.impl.DriverImpl;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportFactory;

class ConnectorImpl<C>
implements Connector<C> {
    public static int END_OF_STREAM = -1;
    private static int DEFAULT_BUFFER_SIZE = 65536;
    private static int readBufferSize = Integer.getInteger("pn.receive_buffer_size", DEFAULT_BUFFER_SIZE);
    private static int writeBufferSize = Integer.getInteger("pn.send_buffer_size", DEFAULT_BUFFER_SIZE);
    private final Sasl _sasl;
    private final DriverImpl _driver;
    private final Listener<C> _listener;
    private final SocketChannel _channel;
    private final Logger _logger = Logger.getLogger("proton.driver");
    private C _context;
    private Connection _connection;
    private SelectionKey _key;
    private ConnectorState _state = ConnectorState.UNINITIALIZED;
    private ByteBuffer _readBuffer = ByteBuffer.allocate(readBufferSize);
    private int _bytesNotRead = 0;
    private int _bytesNotWritten = 0;
    private ByteBuffer _writeBuffer = ByteBuffer.allocate(writeBufferSize);
    private Transport _transport = null;

    ConnectorImpl(DriverImpl driver, Listener<C> listener, Sasl sasl, SocketChannel c, C context, SelectionKey key) {
        this._driver = driver;
        this._listener = listener;
        this._channel = c;
        this._sasl = sasl;
        this._context = context;
        this._key = key;
    }

    @Override
    public void process() {
        if (this._channel.isConnectionPending()) {
            try {
                this._channel.finishConnect();
            }
            catch (IOException io) {
                throw new RuntimeException("Exception will trying to complete connection", io);
            }
        }
        if (!this._channel.isOpen()) {
            this._state = ConnectorState.CLOSED;
            return;
        }
        if (this._key.isReadable()) {
            this.read();
        }
        this.write();
    }

    void read() {
        try {
            int bytesRead = this._channel.read(this._readBuffer);
            int consumed = 0;
            while (bytesRead > 0) {
                consumed = this.processInput(this._readBuffer.array(), 0, bytesRead + this._bytesNotRead);
                if (consumed < bytesRead) {
                    this._readBuffer.compact();
                    this._bytesNotRead = bytesRead - consumed;
                } else {
                    this._readBuffer.rewind();
                    this._bytesNotRead = 0;
                }
                bytesRead = this._channel.read(this._readBuffer);
            }
            if (bytesRead == -1) {
                this._state = ConnectorState.EOS;
            }
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, "Exception when reading from connection", e);
        }
    }

    void write() {
        try {
            this.processOutput();
            if (this._bytesNotWritten > 0) {
                this._writeBuffer.limit(this._bytesNotWritten);
                int written = this._channel.write(this._writeBuffer);
                if (this._writeBuffer.hasRemaining()) {
                    this._writeBuffer.compact();
                    this._bytesNotWritten -= written;
                } else {
                    this._writeBuffer.clear();
                    this._bytesNotWritten = 0;
                }
                if (this._bytesNotWritten > 0) {
                    this._key.interestOps(this._key.interestOps() | 4);
                } else if ((this._key.interestOps() & 4) != 0) {
                    this._key.interestOps(this._key.interestOps() & 0xFFFFFFFB);
                }
            }
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, "Exception when writing to connection", e);
        }
    }

    int processInput(byte[] bytes, int offset, int size) {
        int read = 0;
        while (read < size) {
            offset = read;
            switch (this._state) {
                case UNINITIALIZED: {
                    read += this.readSasl(bytes, offset, size - offset);
                    if (!this.isSaslDone()) break;
                    this._state = this._sasl.getState() == Sasl.SaslState.PN_SASL_PASS ? ConnectorState.OPENED : ConnectorState.CLOSED;
                    break;
                }
                case OPENED: {
                    read += this.readAMQPCommands(bytes, offset, size - offset);
                    break;
                }
            }
        }
        return read;
    }

    void processOutput() {
        switch (this._state) {
            case UNINITIALIZED: {
                this.writeSasl();
                if (!this.isSaslDone()) break;
                this._state = this._sasl.getState() == Sasl.SaslState.PN_SASL_PASS ? ConnectorState.OPENED : ConnectorState.CLOSED;
                break;
            }
            case OPENED: {
                this.writeAMQPCommands();
                break;
            }
            case EOS: {
                this.writeAMQPCommands();
            }
        }
    }

    int readAMQPCommands(byte[] bytes, int offset, int size) {
        int consumed = this._transport.input(bytes, offset, size);
        if (consumed == END_OF_STREAM) {
            return size;
        }
        return consumed;
    }

    void writeAMQPCommands() {
        int size = this._writeBuffer.array().length - this._bytesNotWritten;
        this._bytesNotWritten += this._transport.output(this._writeBuffer.array(), this._bytesNotWritten, size);
    }

    int readSasl(byte[] bytes, int offset, int size) {
        int consumed = this._sasl.input(bytes, offset, size);
        if (consumed == END_OF_STREAM) {
            return size;
        }
        return consumed;
    }

    void writeSasl() {
        int size = this._writeBuffer.array().length - this._bytesNotWritten;
        this._bytesNotWritten += this._sasl.output(this._writeBuffer.array(), this._bytesNotWritten, size);
    }

    @Override
    public Listener<C> listener() {
        return this._listener;
    }

    @Override
    public Sasl sasl() {
        return this._sasl;
    }

    @Override
    public Connection getConnection() {
        return this._connection;
    }

    @Override
    public void setConnection(Connection connection) {
        this._connection = connection;
        this._transport = TransportFactory.getDefaultTransportFactory().transport(this._connection);
    }

    @Override
    public C getContext() {
        return this._context;
    }

    @Override
    public void setContext(C context) {
        this._context = context;
    }

    @Override
    public void close() {
        if (this._state == ConnectorState.CLOSED) {
            return;
        }
        try {
            this.writeSasl();
            this.writeAMQPCommands();
            this._channel.close();
            this._state = ConnectorState.CLOSED;
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, "Exception when closing connection", e);
        }
    }

    @Override
    public boolean isClosed() {
        return this._state == ConnectorState.EOS || this._state == ConnectorState.CLOSED;
    }

    @Override
    public void destroy() {
        this.close();
    }

    private void setState(ConnectorState newState) {
        this._state = newState;
    }

    private boolean isSaslDone() {
        Sasl.SaslState state = this._sasl.getState();
        return state == Sasl.SaslState.PN_SASL_PASS || state == Sasl.SaslState.PN_SASL_FAIL;
    }

    static enum ConnectorState {
        UNINITIALIZED,
        OPENED,
        EOS,
        CLOSED;

    }
}

