/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.driver.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.driver.Connector;
import org.apache.qpid.proton.driver.Driver;
import org.apache.qpid.proton.driver.Listener;
import org.apache.qpid.proton.driver.impl.ConnectorImpl;
import org.apache.qpid.proton.driver.impl.ListenerImpl;
import org.apache.qpid.proton.engine.impl.SaslClientImpl;
import org.apache.qpid.proton.engine.impl.SaslServerImpl;

public class DriverImpl
implements Driver {
    private Selector _selector;
    private Set<SelectionKey> _selectedKeys = Collections.emptySet();
    private Logger _logger = Logger.getLogger("proton.driver");

    public DriverImpl() throws IOException {
        this._selector = Selector.open();
    }

    @Override
    public void wakeup() {
        this._selector.wakeup();
    }

    @Override
    public void doWait(int timeout) {
        try {
            this._selector.select(timeout);
            this._selectedKeys = this._selector.selectedKeys();
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, "Exception when waiting for IO Event", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Listener listener() {
        Listener listener = null;
        listener = this.getFirstListener();
        if (listener == null) {
            try {
                this.selectNow();
            }
            catch (IOException e) {
                this._logger.log(Level.SEVERE, "Exception when selecting", e);
                throw new RuntimeException(e);
            }
            listener = this.getFirstListener();
        }
        return listener;
    }

    private void selectNow() throws IOException {
        this._selector.selectNow();
        this._selectedKeys = this._selector.selectedKeys();
    }

    private Listener getFirstListener() {
        Iterator<SelectionKey> selectedIter = this._selectedKeys.iterator();
        while (selectedIter.hasNext()) {
            SelectionKey key = selectedIter.next();
            selectedIter.remove();
            if (!key.isAcceptable()) continue;
            return (Listener)key.attachment();
        }
        return null;
    }

    @Override
    public Connector connector() {
        Connector connector = null;
        connector = this.getFirstConnector();
        if (connector == null) {
            try {
                this.selectNow();
            }
            catch (IOException e) {
                this._logger.log(Level.SEVERE, "Exception when selecting", e);
                throw new RuntimeException(e);
            }
            connector = this.getFirstConnector();
        }
        return connector;
    }

    private Connector getFirstConnector() {
        Iterator<SelectionKey> selectedIter = this._selectedKeys.iterator();
        while (selectedIter.hasNext()) {
            SelectionKey key = selectedIter.next();
            selectedIter.remove();
            if (!key.isReadable() && !key.isWritable()) continue;
            return (Connector)key.attachment();
        }
        return null;
    }

    @Override
    public void destroy() {
        try {
            this._selector.close();
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, "Exception when closing selector", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public <C> Listener<C> createListener(String host, int port, C context) {
        try {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.configureBlocking(false);
            ServerSocket serverSocket = serverSocketChannel.socket();
            serverSocket.bind(new InetSocketAddress(host, port));
            return this.createListener(serverSocketChannel, context);
        }
        catch (ClosedChannelException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public <C> Listener<C> createListener(ServerSocketChannel c, C context) {
        ListenerImpl<C> l = new ListenerImpl<C>(this, c, context);
        SelectionKey key = this.registerInterest(c, 16);
        key.attach(l);
        return l;
    }

    @Override
    public <C> Connector<C> createConnector(String host, int port, C context) {
        try {
            SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            channel.connect(new InetSocketAddress(host, port));
            return this.createConnector(channel, context);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public <C> Connector<C> createConnector(SelectableChannel c, C context) {
        SelectionKey key = this.registerInterest(c, 1);
        ConnectorImpl<C> co = new ConnectorImpl<C>(this, null, new SaslClientImpl(), (SocketChannel)c, context, key);
        key.attach(co);
        return co;
    }

    protected <C> Connector<C> createServerConnector(SelectableChannel c, C context, Listener<C> l) {
        SelectionKey key = this.registerInterest(c, 1);
        ConnectorImpl<C> co = new ConnectorImpl<C>(this, l, new SaslServerImpl(), (SocketChannel)c, context, key);
        key.attach(co);
        return co;
    }

    private <C> SelectionKey registerInterest(SelectableChannel c, int opKeys) {
        try {
            return c.register(this._selector, opKeys);
        }
        catch (ClosedChannelException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

