/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.SaslClient;
import org.apache.qpid.proton.engine.impl.SaslImpl;
import org.apache.qpid.proton.type.Binary;
import org.apache.qpid.proton.type.Symbol;
import org.apache.qpid.proton.type.security.SaslChallenge;
import org.apache.qpid.proton.type.security.SaslFrameBody;
import org.apache.qpid.proton.type.security.SaslInit;
import org.apache.qpid.proton.type.security.SaslMechanisms;
import org.apache.qpid.proton.type.security.SaslOutcome;
import org.apache.qpid.proton.type.security.SaslResponse;

public class SaslClientImpl
extends SaslImpl
implements SaslClient,
SaslFrameBody.SaslFrameBodyHandler<Void> {
    private Sasl.SaslOutcome _outcome = Sasl.SaslOutcome.PN_SASL_NONE;
    private Sasl.SaslState _state = Sasl.SaslState.PN_SASL_IDLE;
    private Symbol[] _mechanisms;
    private Symbol _chosenMechanism;
    private boolean _done;
    private String _hostname;

    @Override
    public Sasl.SaslState getState() {
        return this._state;
    }

    @Override
    public void setMechanisms(String[] mechanisms) {
        assert (mechanisms != null);
        assert (mechanisms.length == 1);
        this._chosenMechanism = Symbol.valueOf(mechanisms[0]);
    }

    @Override
    public String[] getRemoteMechanisms() {
        String[] remoteMechanisms = new String[this._mechanisms.length];
        for (int i = 0; i < this._mechanisms.length; ++i) {
            remoteMechanisms[i] = this._mechanisms[i].toString();
        }
        return remoteMechanisms;
    }

    @Override
    public void handleMechanisms(SaslMechanisms saslMechanisms, Binary payload, Void context) {
        this._mechanisms = saslMechanisms.getSaslServerMechanisms();
    }

    @Override
    public void handleInit(SaslInit saslInit, Binary payload, Void context) {
    }

    @Override
    public void handleChallenge(SaslChallenge saslChallenge, Binary payload, Void context) {
        this.setPending(saslChallenge.getChallenge() == null ? null : saslChallenge.getChallenge().asByteBuffer());
    }

    @Override
    public void handleResponse(SaslResponse saslResponse, Binary payload, Void context) {
    }

    @Override
    public void handleOutcome(SaslOutcome saslOutcome, Binary payload, Void context) {
        for (Sasl.SaslOutcome outcome : Sasl.SaslOutcome.values()) {
            if (outcome.getCode() != saslOutcome.getCode().byteValue()) continue;
            this._outcome = outcome;
            break;
        }
        this._done = true;
    }

    @Override
    public boolean isDone() {
        return this._done;
    }

    @Override
    protected int process(WritableBuffer buffer) {
        int written = this.processHeader(buffer);
        if (this.getState() == Sasl.SaslState.PN_SASL_IDLE && this._chosenMechanism != null) {
            written += this.processInit(buffer);
            this._state = Sasl.SaslState.PN_SASL_STEP;
        }
        if (this.getState() == Sasl.SaslState.PN_SASL_STEP && this.getChallengeResponse() != null) {
            written += this.processResponse(buffer);
        }
        return written;
    }

    private int processResponse(WritableBuffer buffer) {
        SaslResponse response = new SaslResponse();
        response.setResponse(this.getChallengeResponse());
        this.setChallengeResponse(null);
        return this.writeFrame(buffer, response);
    }

    private int processInit(WritableBuffer buffer) {
        SaslInit init = new SaslInit();
        init.setHostname(this._hostname);
        init.setMechanism(this._chosenMechanism);
        if (this.getChallengeResponse() != null) {
            init.setInitialResponse(this.getChallengeResponse());
            this.setChallengeResponse(null);
        }
        return this.writeFrame(buffer, init);
    }

    @Override
    public void plain(String username, String password) {
        this._chosenMechanism = Symbol.valueOf("PLAIN");
        byte[] usernameBytes = username.getBytes();
        byte[] passwordBytes = password.getBytes();
        byte[] data = new byte[usernameBytes.length + passwordBytes.length + 2];
        System.arraycopy(usernameBytes, 0, data, 1, usernameBytes.length);
        System.arraycopy(passwordBytes, 0, data, 2 + usernameBytes.length, passwordBytes.length);
        this.setChallengeResponse(new Binary(data));
    }

    @Override
    public Sasl.SaslOutcome getOutcome() {
        return this._outcome;
    }
}

