/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.SaslServer;
import org.apache.qpid.proton.engine.impl.SaslImpl;
import org.apache.qpid.proton.type.Binary;
import org.apache.qpid.proton.type.Symbol;
import org.apache.qpid.proton.type.UnsignedByte;
import org.apache.qpid.proton.type.security.SaslChallenge;
import org.apache.qpid.proton.type.security.SaslFrameBody;
import org.apache.qpid.proton.type.security.SaslInit;
import org.apache.qpid.proton.type.security.SaslMechanisms;
import org.apache.qpid.proton.type.security.SaslOutcome;
import org.apache.qpid.proton.type.security.SaslResponse;

public class SaslServerImpl
extends SaslImpl
implements SaslServer,
SaslFrameBody.SaslFrameBodyHandler<Void> {
    private static final byte SASL_FRAME_TYPE = 1;
    private Sasl.SaslOutcome _outcome = Sasl.SaslOutcome.PN_SASL_NONE;
    private Sasl.SaslState _state = Sasl.SaslState.PN_SASL_IDLE;
    private String _hostname;
    private String _chosenMechanism;
    private boolean _done;
    private Symbol[] _mechanisms;

    @Override
    public void done(Sasl.SaslOutcome outcome) {
        this._outcome = outcome;
        this._done = true;
        this._state = outcome == Sasl.SaslOutcome.PN_SASL_OK ? Sasl.SaslState.PN_SASL_PASS : Sasl.SaslState.PN_SASL_FAIL;
    }

    @Override
    protected int process(WritableBuffer outputBuffer) {
        int written = this.processHeader(outputBuffer);
        if (this.getState() == Sasl.SaslState.PN_SASL_IDLE && this._mechanisms != null) {
            SaslMechanisms mechanisms = new SaslMechanisms();
            mechanisms.setSaslServerMechanisms(this._mechanisms);
            written += this.writeFrame(outputBuffer, mechanisms);
        } else if (this.getChallengeResponse() != null) {
            SaslChallenge challenge = new SaslChallenge();
            challenge.setChallenge(this.getChallengeResponse());
            written += this.writeFrame(outputBuffer, challenge);
            this.setChallengeResponse(null);
        } else if (this._done) {
            SaslOutcome outcome = new SaslOutcome();
            outcome.setCode(UnsignedByte.valueOf(this._outcome.getCode()));
            written += this.writeFrame(outputBuffer, outcome);
        }
        return written;
    }

    @Override
    public Sasl.SaslState getState() {
        return this._state;
    }

    @Override
    public void setMechanisms(String[] mechanisms) {
        if (mechanisms != null) {
            this._mechanisms = new Symbol[mechanisms.length];
            for (int i = 0; i < mechanisms.length; ++i) {
                this._mechanisms[i] = Symbol.valueOf(mechanisms[i]);
            }
        }
    }

    @Override
    public String[] getRemoteMechanisms() {
        return new String[]{this._chosenMechanism};
    }

    @Override
    public void setMechanism(Symbol mechanism) {
        this._chosenMechanism = mechanism.toString();
    }

    @Override
    public void setResponse(Binary initialResponse) {
        this.setPending(initialResponse.asByteBuffer());
    }

    @Override
    public void handleMechanisms(SaslMechanisms saslMechanisms, Binary payload, Void context) {
    }

    @Override
    public void handleInit(SaslInit saslInit, Binary payload, Void context) {
        this._hostname = saslInit.getHostname();
        if (saslInit.getInitialResponse() != null) {
            this.setPending(saslInit.getInitialResponse().asByteBuffer());
        }
    }

    @Override
    public void handleChallenge(SaslChallenge saslChallenge, Binary payload, Void context) {
    }

    @Override
    public void handleResponse(SaslResponse saslResponse, Binary payload, Void context) {
        this.setPending(saslResponse.getResponse() == null ? null : saslResponse.getResponse().asByteBuffer());
    }

    @Override
    public void handleOutcome(SaslOutcome saslOutcome, Binary payload, Void context) {
    }

    @Override
    public boolean isDone() {
        return this._done;
    }
}

