/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.codec.CompositeWritableBuffer;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointError;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.FrameTransport;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.TransportInput;
import org.apache.qpid.proton.engine.TransportOutput;
import org.apache.qpid.proton.engine.TransportWrapper;
import org.apache.qpid.proton.engine.impl.ConnectionImpl;
import org.apache.qpid.proton.engine.impl.DeliveryImpl;
import org.apache.qpid.proton.engine.impl.EndpointImpl;
import org.apache.qpid.proton.engine.impl.FrameParser;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.engine.impl.ReceiverImpl;
import org.apache.qpid.proton.engine.impl.SaslImpl;
import org.apache.qpid.proton.engine.impl.SenderImpl;
import org.apache.qpid.proton.engine.impl.SessionImpl;
import org.apache.qpid.proton.engine.impl.TransportDelivery;
import org.apache.qpid.proton.engine.impl.TransportLink;
import org.apache.qpid.proton.engine.impl.TransportSender;
import org.apache.qpid.proton.engine.impl.TransportSession;
import org.apache.qpid.proton.framing.TransportFrame;
import org.apache.qpid.proton.type.AMQPDefinedTypes;
import org.apache.qpid.proton.type.Binary;
import org.apache.qpid.proton.type.DescribedType;
import org.apache.qpid.proton.type.Symbol;
import org.apache.qpid.proton.type.UnsignedInteger;
import org.apache.qpid.proton.type.UnsignedShort;
import org.apache.qpid.proton.type.messaging.Accepted;
import org.apache.qpid.proton.type.transport.Attach;
import org.apache.qpid.proton.type.transport.Begin;
import org.apache.qpid.proton.type.transport.Close;
import org.apache.qpid.proton.type.transport.Detach;
import org.apache.qpid.proton.type.transport.Disposition;
import org.apache.qpid.proton.type.transport.End;
import org.apache.qpid.proton.type.transport.Error;
import org.apache.qpid.proton.type.transport.Flow;
import org.apache.qpid.proton.type.transport.FrameBody;
import org.apache.qpid.proton.type.transport.Open;
import org.apache.qpid.proton.type.transport.Transfer;

public class TransportImpl
extends EndpointImpl
implements Transport,
FrameBody.FrameBodyHandler<Integer>,
FrameTransport {
    public static final int SESSION_WINDOW = 1024;
    public static final byte[] HEADER = new byte[8];
    public static final Accepted ACCEPTED = new Accepted();
    private ConnectionImpl _connectionEndpoint;
    private boolean _isOpenSent;
    private boolean _isCloseSent;
    private boolean _headerWritten;
    private TransportSession[] _remoteSessions;
    private TransportSession[] _localSessions;
    private TransportInput _inputProcessor;
    private TransportOutput _outputProcessor;
    private Map<SessionImpl, TransportSession> _transportSessionState = new HashMap<SessionImpl, TransportSession>();
    private Map<LinkImpl, TransportLink> _transportLinkState = new HashMap<LinkImpl, TransportLink>();
    private DecoderImpl _decoder = new DecoderImpl();
    private EncoderImpl _encoder = new EncoderImpl(this._decoder);
    private int _maxFrameSize = 16384;
    private final ByteBuffer _overflowBuffer = ByteBuffer.wrap(new byte[this._maxFrameSize]);
    private static final byte AMQP_FRAME_TYPE = 0;
    private boolean _closeReceived;
    private Open _open;
    private SaslImpl _sasl;
    private TransportException _inputException;
    private ProtocolTracer _protocolTracer = null;

    public TransportImpl() {
        AMQPDefinedTypes.registerAllTypes(this._decoder);
        this._overflowBuffer.flip();
        FrameParser frameParser = new FrameParser(this);
        this._inputProcessor = frameParser;
        this._outputProcessor = new TransportOutput(){

            @Override
            public int output(byte[] bytes, int offset, int size) {
                return TransportImpl.this.transportOutput(bytes, offset, size);
            }
        };
    }

    @Override
    public void bind(Connection conn) {
        ((ConnectionImpl)conn).setBound(true);
        this._connectionEndpoint = (ConnectionImpl)conn;
        this._localSessions = new TransportSession[this._connectionEndpoint.getMaxChannels() + 1];
        this._remoteSessions = new TransportSession[this._connectionEndpoint.getMaxChannels() + 1];
        if (this.getRemoteState() != EndpointState.UNINITIALIZED) {
            this._connectionEndpoint.handleOpen(this._open);
            if (this.getRemoteState() == EndpointState.CLOSED) {
                this._connectionEndpoint.setRemoteState(EndpointState.CLOSED);
            }
            this._inputProcessor.input(new byte[0], 0, 0);
        }
    }

    @Override
    public int input(byte[] bytes, int offset, int length) {
        if (this._inputException != null) {
            throw this._inputException;
        }
        if (length == 0 && (this._connectionEndpoint == null || this._connectionEndpoint.getRemoteState() != EndpointState.CLOSED)) {
            throw new TransportException("Unexpected EOS: connection aborted");
        }
        try {
            return this._inputProcessor.input(bytes, offset, length);
        }
        catch (TransportException e) {
            this._inputException = e;
            throw e;
        }
    }

    @Override
    public int output(byte[] bytes, int offset, int size) {
        try {
            return this._outputProcessor.output(bytes, offset, size);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private int transportOutput(byte[] bytes, int offset, int size) {
        int written = 0;
        if (this._overflowBuffer.hasRemaining()) {
            int overflowWritten = Math.min(size, this._overflowBuffer.remaining());
            this._overflowBuffer.get(bytes, offset, overflowWritten);
            written += overflowWritten;
        }
        if (!this._overflowBuffer.hasRemaining()) {
            this._overflowBuffer.clear();
            CompositeWritableBuffer outputBuffer = new CompositeWritableBuffer(new WritableBuffer.ByteBufferWrapper(ByteBuffer.wrap(bytes, offset + written, size - written)), new WritableBuffer.ByteBufferWrapper(this._overflowBuffer));
            written += this.processHeader(outputBuffer);
            written += this.processOpen(outputBuffer);
            written += this.processBegin(outputBuffer);
            written += this.processAttach(outputBuffer);
            written += this.processReceiverFlow(outputBuffer);
            written += this.processReceiverDisposition(outputBuffer);
            written += this.processReceiverFlow(outputBuffer);
            written += this.processMessageData(outputBuffer);
            written += this.processSenderDisposition(outputBuffer);
            written += this.processSenderFlow(outputBuffer);
            written += this.processDetach(outputBuffer);
            written += this.processEnd(outputBuffer);
            written += this.processClose(outputBuffer);
            this._overflowBuffer.flip();
        }
        return written - this._overflowBuffer.remaining();
    }

    @Override
    public Sasl sasl() {
        if (this._sasl == null) {
            this._sasl = new SaslImpl();
            TransportWrapper transportWrapper = this._sasl.wrap(this._inputProcessor, this._outputProcessor);
            this._inputProcessor = transportWrapper;
            this._outputProcessor = transportWrapper;
        }
        return this._sasl;
    }

    private void clearTransportWorkList() {
        DeliveryImpl delivery = this._connectionEndpoint.getTransportWorkHead();
        while (delivery != null) {
            DeliveryImpl transportWorkNext = delivery.getTransportWorkNext();
            delivery.clearTransportWork();
            delivery = transportWorkNext;
        }
    }

    private int processDetach(WritableBuffer buffer) {
        int written = 0;
        if (this._connectionEndpoint != null) {
            for (EndpointImpl endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null && buffer.remaining() >= this._maxFrameSize; endpoint = endpoint.transportNext()) {
                if (!(endpoint instanceof LinkImpl)) continue;
                LinkImpl link = (LinkImpl)endpoint;
                TransportLink transportLink = this.getTransportState(link);
                SessionImpl session = link.getSession();
                TransportSession transportSession = this.getTransportState(session);
                if (link.getLocalState() != EndpointState.CLOSED || !transportLink.isLocalHandleSet() || link instanceof SenderImpl && link.getQueued() != 0 && !transportLink.detachReceived() && !transportSession.endReceived() && !this._closeReceived) continue;
                UnsignedInteger localHandle = transportLink.getLocalHandle();
                transportLink.clearLocalHandle();
                transportSession.freeLocalHandle(localHandle);
                Detach detach = new Detach();
                detach.setHandle(localHandle);
                EndpointError localError = link.getLocalError();
                if (localError != null) {
                    Error error = new Error();
                    error.setCondition(Symbol.getSymbol(localError.getName()));
                    error.setDescription(localError.getDescription());
                    detach.setError(error);
                }
                int frameBytes = this.writeFrame(buffer, transportSession.getLocalChannel(), detach, null, null);
                written += frameBytes;
                endpoint.clearModified();
            }
        }
        return written;
    }

    private int processSenderFlow(WritableBuffer buffer) {
        int written = 0;
        if (this._connectionEndpoint != null) {
            for (EndpointImpl endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null && buffer.remaining() >= this._maxFrameSize; endpoint = endpoint.transportNext()) {
                SenderImpl sender;
                if (!(endpoint instanceof SenderImpl) || !(sender = (SenderImpl)endpoint).getDrain() || !sender.clearDrained()) continue;
                TransportSender transportLink = sender.getTransportLink();
                TransportSession transportSession = sender.getSession().getTransportSession();
                UnsignedInteger credits = transportLink.getLinkCredit();
                transportLink.setLinkCredit(UnsignedInteger.valueOf(0));
                transportLink.setDeliveryCount(transportLink.getDeliveryCount().add(credits));
                transportLink.setLinkCredit(UnsignedInteger.ZERO);
                Flow flow = new Flow();
                flow.setHandle(transportLink.getLocalHandle());
                flow.setNextIncomingId(transportSession.getNextIncomingId());
                flow.setIncomingWindow(transportSession.getIncomingWindowSize());
                flow.setOutgoingWindow(transportSession.getOutgoingWindowSize());
                flow.setDeliveryCount(transportLink.getDeliveryCount());
                flow.setLinkCredit(transportLink.getLinkCredit());
                flow.setDrain(sender.getDrain());
                flow.setNextOutgoingId(transportSession.getNextOutgoingId());
                int frameBytes = this.writeFrame(buffer, transportSession.getLocalChannel(), flow, null, null);
                written += frameBytes;
                endpoint.clearModified();
            }
        }
        return written;
    }

    private int processSenderDisposition(WritableBuffer buffer) {
        int written = 0;
        if (this._connectionEndpoint != null) {
            DeliveryImpl delivery = this._connectionEndpoint.getTransportWorkHead();
            while (delivery != null && buffer.remaining() >= this._maxFrameSize) {
                if (delivery.getLink() instanceof SenderImpl && delivery.isLocalStateChange() && delivery.getTransportDelivery() != null) {
                    TransportDelivery transportDelivery = delivery.getTransportDelivery();
                    Disposition disposition = new Disposition();
                    disposition.setFirst(transportDelivery.getDeliveryId());
                    disposition.setLast(transportDelivery.getDeliveryId());
                    disposition.setRole(false);
                    disposition.setSettled(delivery.isSettled());
                    if (delivery.isSettled()) {
                        transportDelivery.settled();
                    }
                    disposition.setState(delivery.getLocalState());
                    int frameBytes = this.writeFrame(buffer, delivery.getLink().getSession().getTransportSession().getLocalChannel(), disposition, null, null);
                    written += frameBytes;
                    delivery = delivery.clearTransportWork();
                    continue;
                }
                delivery = delivery.getTransportWorkNext();
            }
        }
        return written;
    }

    private int processMessageData(WritableBuffer buffer) {
        int written = 0;
        if (this._connectionEndpoint != null) {
            DeliveryImpl delivery = this._connectionEndpoint.getTransportWorkHead();
            while (delivery != null && buffer.remaining() >= this._maxFrameSize) {
                if (delivery.getLink() instanceof SenderImpl && (!delivery.isDone() || delivery.getDataLength() != 0) && delivery.getLink().getSession().getTransportSession().hasOutgoingCredit()) {
                    SenderImpl sender = (SenderImpl)delivery.getLink();
                    sender.decrementQueued();
                    TransportSender transportLink = sender.getTransportLink();
                    UnsignedInteger deliveryId = transportLink.getDeliveryCount();
                    TransportDelivery transportDelivery = new TransportDelivery(deliveryId, delivery, transportLink);
                    delivery.setTransportDelivery(transportDelivery);
                    sender.getSession().getTransportSession().addUnsettledOutgoing(deliveryId, delivery);
                    Transfer transfer = new Transfer();
                    transfer.setDeliveryId(deliveryId);
                    transfer.setDeliveryTag(new Binary(delivery.getTag()));
                    transfer.setHandle(transportLink.getLocalHandle());
                    if (delivery.isSettled()) {
                        transfer.setSettled(Boolean.TRUE);
                    }
                    if (delivery.getLink().current() == delivery) {
                        transfer.setMore(true);
                    }
                    transfer.setMessageFormat(UnsignedInteger.ZERO);
                    ByteBuffer payload = delivery.getData() == null ? null : ByteBuffer.wrap(delivery.getData(), delivery.getDataOffset(), delivery.getDataLength());
                    int frameBytes = this.writeFrame(buffer, sender.getSession().getTransportSession().getLocalChannel(), transfer, payload, new PartialTransfer(transfer));
                    sender.getSession().getTransportSession().incrementOutgoingId();
                    written += frameBytes;
                    if (payload == null || !payload.hasRemaining()) {
                        delivery.setData(null);
                        delivery.setDataLength(0);
                        delivery.setDone();
                        if (delivery.getLink().current() != delivery) {
                            transportLink.setDeliveryCount(transportLink.getDeliveryCount().add(UnsignedInteger.ONE));
                            transportLink.setLinkCredit(transportLink.getLinkCredit().subtract(UnsignedInteger.ONE));
                        }
                        delivery = delivery.clearTransportWork();
                        continue;
                    }
                    delivery.setDataOffset(delivery.getDataOffset() + delivery.getDataLength() - payload.remaining());
                    delivery.setDataLength(payload.remaining());
                    continue;
                }
                delivery = delivery.getTransportWorkNext();
            }
        }
        return written;
    }

    private int processReceiverDisposition(WritableBuffer buffer) {
        int written = 0;
        if (this._connectionEndpoint != null) {
            DeliveryImpl delivery = this._connectionEndpoint.getTransportWorkHead();
            while (delivery != null && buffer.remaining() >= this._maxFrameSize) {
                boolean remove = false;
                if (delivery.getLink() instanceof ReceiverImpl && delivery.isLocalStateChange()) {
                    remove = true;
                    TransportDelivery transportDelivery = delivery.getTransportDelivery();
                    Disposition disposition = new Disposition();
                    disposition.setFirst(transportDelivery.getDeliveryId());
                    disposition.setLast(transportDelivery.getDeliveryId());
                    disposition.setRole(true);
                    disposition.setSettled(delivery.isSettled());
                    disposition.setState(delivery.getLocalState());
                    int frameBytes = this.writeFrame(buffer, delivery.getLink().getSession().getTransportSession().getLocalChannel(), disposition, null, null);
                    written += frameBytes;
                    if (delivery.isSettled()) {
                        transportDelivery.settled();
                    }
                    delivery = delivery.clearTransportWork();
                    continue;
                }
                delivery = delivery.getTransportWorkNext();
            }
        }
        return written;
    }

    private int processReceiverFlow(WritableBuffer buffer) {
        int written = 0;
        if (this._connectionEndpoint != null) {
            EndpointImpl endpoint;
            for (endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null && buffer.remaining() >= this._maxFrameSize; endpoint = endpoint.transportNext()) {
                if (!(endpoint instanceof ReceiverImpl)) continue;
                ReceiverImpl receiver = (ReceiverImpl)endpoint;
                TransportLink transportLink = this.getTransportState(receiver);
                TransportSession transportSession = this.getTransportState(receiver.getSession());
                if (receiver.getLocalState() != EndpointState.ACTIVE) continue;
                int credits = receiver.clearUnsentCredits();
                transportSession.getSession().clearIncomingWindowResize();
                if (credits == 0 && !receiver.getDrain()) continue;
                transportLink.addCredit(credits);
                Flow flow = new Flow();
                flow.setHandle(transportLink.getLocalHandle());
                flow.setNextIncomingId(transportSession.getNextIncomingId());
                flow.setIncomingWindow(transportSession.getIncomingWindowSize());
                flow.setOutgoingWindow(transportSession.getOutgoingWindowSize());
                flow.setDeliveryCount(transportLink.getDeliveryCount());
                flow.setLinkCredit(transportLink.getLinkCredit());
                flow.setDrain(receiver.getDrain());
                flow.setNextOutgoingId(transportSession.getNextOutgoingId());
                int frameBytes = this.writeFrame(buffer, transportSession.getLocalChannel(), flow, null, null);
                written += frameBytes;
                if (receiver.getLocalState() != EndpointState.ACTIVE) continue;
                endpoint.clearModified();
            }
            for (endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null && buffer.remaining() >= this._maxFrameSize; endpoint = endpoint.transportNext()) {
                boolean windowResized;
                if (!(endpoint instanceof SessionImpl)) continue;
                SessionImpl session = (SessionImpl)endpoint;
                TransportSession transportSession = this.getTransportState(session);
                if (session.getLocalState() != EndpointState.ACTIVE || !(windowResized = session.clearIncomingWindowResize())) continue;
                Flow flow = new Flow();
                flow.setIncomingWindow(transportSession.getIncomingWindowSize());
                flow.setOutgoingWindow(transportSession.getOutgoingWindowSize());
                flow.setNextOutgoingId(transportSession.getNextOutgoingId());
                flow.setNextIncomingId(transportSession.getNextIncomingId());
                int frameBytes = this.writeFrame(buffer, transportSession.getLocalChannel(), flow, null, null);
                written += frameBytes;
            }
        }
        return written;
    }

    private int processAttach(WritableBuffer buffer) {
        int written = 0;
        if (this._connectionEndpoint != null) {
            for (EndpointImpl endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null && buffer.remaining() >= this._maxFrameSize; endpoint = endpoint.transportNext()) {
                if (!(endpoint instanceof LinkImpl)) continue;
                LinkImpl link = (LinkImpl)endpoint;
                TransportLink transportLink = this.getTransportState(link);
                if (link.getLocalState() == EndpointState.UNINITIALIZED || transportLink.attachSent() || (link.getRemoteState() != EndpointState.ACTIVE || transportLink.isLocalHandleSet()) && link.getRemoteState() != EndpointState.UNINITIALIZED) continue;
                SessionImpl session = link.getSession();
                TransportSession transportSession = this.getTransportState(session);
                UnsignedInteger localHandle = transportSession.allocateLocalHandle(transportLink);
                if (link.getRemoteState() == EndpointState.UNINITIALIZED) {
                    transportSession.addHalfOpenLink(transportLink);
                }
                Attach attach = new Attach();
                attach.setHandle(localHandle);
                attach.setName(transportLink.getName());
                if (link.getSenderSettleMode() != null) {
                    attach.setSndSettleMode(link.getSenderSettleMode());
                }
                if (link.getReceiverSettleMode() != null) {
                    attach.setRcvSettleMode(link.getReceiverSettleMode());
                }
                if (link.getSource() != null) {
                    attach.setSource(link.getSource());
                }
                if (link.getTarget() != null) {
                    attach.setTarget(link.getTarget());
                }
                attach.setRole(endpoint instanceof ReceiverImpl);
                if (link instanceof SenderImpl) {
                    attach.setInitialDeliveryCount(UnsignedInteger.ZERO);
                }
                int frameBytes = this.writeFrame(buffer, transportSession.getLocalChannel(), attach, null, null);
                written += frameBytes;
                transportLink.sentAttach();
                if (link.getLocalState() != EndpointState.ACTIVE || !(link instanceof SenderImpl) && link.hasCredit()) continue;
                endpoint.clearModified();
            }
        }
        return written;
    }

    private void clearInterestList() {
        for (EndpointImpl endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null; endpoint = endpoint.transportNext()) {
            endpoint.clearModified();
        }
    }

    private int processHeader(WritableBuffer buffer) {
        if (!this._headerWritten) {
            buffer.put(HEADER, 0, HEADER.length);
            this._headerWritten = true;
            return HEADER.length;
        }
        return 0;
    }

    private int processOpen(WritableBuffer buffer) {
        if (this._connectionEndpoint != null && this._connectionEndpoint.getLocalState() != EndpointState.UNINITIALIZED && !this._isOpenSent) {
            Open open = new Open();
            open.setContainerId(this._connectionEndpoint.getLocalContainerId());
            open.setHostname(this._connectionEndpoint.getHostname());
            this._isOpenSent = true;
            return this.writeFrame(buffer, 0, open, null, null);
        }
        return 0;
    }

    private int processBegin(WritableBuffer buffer) {
        int written = 0;
        if (this._connectionEndpoint != null) {
            for (EndpointImpl endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null && buffer.remaining() >= this._maxFrameSize; endpoint = endpoint.transportNext()) {
                if (!(endpoint instanceof SessionImpl)) continue;
                SessionImpl session = (SessionImpl)endpoint;
                TransportSession transportSession = this.getTransportState(session);
                if (session.getLocalState() == EndpointState.UNINITIALIZED || transportSession.beginSent()) continue;
                int channelId = this.allocateLocalChannel(transportSession);
                Begin begin = new Begin();
                if (session.getRemoteState() != EndpointState.UNINITIALIZED) {
                    begin.setRemoteChannel(UnsignedShort.valueOf((short)transportSession.getRemoteChannel()));
                }
                begin.setHandleMax(transportSession.getHandleMax());
                begin.setIncomingWindow(transportSession.getIncomingWindowSize());
                begin.setOutgoingWindow(transportSession.getOutgoingWindowSize());
                begin.setNextOutgoingId(transportSession.getNextOutgoingId());
                written += this.writeFrame(buffer, channelId, begin, null, null);
                transportSession.sentBegin();
                if (session.getLocalState() != EndpointState.ACTIVE) continue;
                endpoint.clearModified();
            }
        }
        return written;
    }

    private TransportSession getTransportState(SessionImpl session) {
        TransportSession transportSession = this._transportSessionState.get(session);
        if (transportSession == null) {
            transportSession = new TransportSession(session);
            session.setTransportSession(transportSession);
            this._transportSessionState.put(session, transportSession);
        }
        return transportSession;
    }

    private TransportLink getTransportState(LinkImpl link) {
        TransportLink<LinkImpl> transportLink = this._transportLinkState.get(link);
        if (transportLink == null) {
            transportLink = TransportLink.createTransportLink(link);
            this._transportLinkState.put(link, transportLink);
        }
        return transportLink;
    }

    private int allocateLocalChannel(TransportSession transportSession) {
        for (int i = 0; i < this._localSessions.length; ++i) {
            if (this._localSessions[i] != null) continue;
            this._localSessions[i] = transportSession;
            transportSession.setLocalChannel(i);
            return i;
        }
        return -1;
    }

    private int freeLocalChannel(TransportSession transportSession) {
        int channel = transportSession.getLocalChannel();
        this._localSessions[channel] = null;
        transportSession.freeLocalChannel();
        return channel;
    }

    private int processEnd(WritableBuffer buffer) {
        int written = 0;
        if (this._connectionEndpoint != null) {
            for (EndpointImpl endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null && buffer.remaining() >= this._maxFrameSize; endpoint = endpoint.transportNext()) {
                TransportSession transportSession;
                SessionImpl session;
                if (!(endpoint instanceof SessionImpl) || (session = (SessionImpl)endpoint).getLocalState() != EndpointState.CLOSED || !(transportSession = session.getTransportSession()).isLocalChannelSet() || this.hasSendableMessages(session)) continue;
                int channel = this.freeLocalChannel(transportSession);
                End end = new End();
                int frameBytes = this.writeFrame(buffer, channel, end, null, null);
                written += frameBytes;
                endpoint.clearModified();
            }
        }
        return written;
    }

    private boolean hasSendableMessages(SessionImpl session) {
        if (!(this._closeReceived || session != null && session.getTransportSession().endReceived())) {
            for (EndpointImpl endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null; endpoint = endpoint.transportNext()) {
                if (!(endpoint instanceof SenderImpl)) continue;
                SenderImpl sender = (SenderImpl)endpoint;
                if (session != null && sender.getSession() != session || sender.getQueued() == 0 || this.getTransportState(sender).detachReceived()) continue;
                return true;
            }
        }
        return false;
    }

    private int processClose(WritableBuffer buffer) {
        if (this._connectionEndpoint != null && this._connectionEndpoint.getLocalState() == EndpointState.CLOSED && !this._isCloseSent && !this.hasSendableMessages(null)) {
            Close close = new Close();
            this._isCloseSent = true;
            return this.writeFrame(buffer, 0, close, null, null);
        }
        return 0;
    }

    private int writeFrame(WritableBuffer buffer, int channel, DescribedType frameBody, ByteBuffer payload, Runnable onPayloadTooLarge) {
        int payloadSize;
        if (this._protocolTracer != null) {
            ByteBuffer originalPayload = null;
            if (payload != null) {
                originalPayload = payload.duplicate();
            }
            this._protocolTracer.sentFrame(new TransportFrame(channel, (FrameBody)((Object)frameBody), Binary.create(originalPayload)));
        }
        int oldPosition = buffer.position();
        buffer.position(buffer.position() + 8);
        this._encoder.setByteBuffer(buffer);
        if (payload == null || payload.remaining() < this._maxFrameSize) {
            this._encoder.writeDescribedType(frameBody);
        }
        if (payload != null && payload.remaining() + buffer.position() - oldPosition > this._maxFrameSize) {
            if (onPayloadTooLarge != null) {
                onPayloadTooLarge.run();
            }
            buffer.position(oldPosition + 8);
            this._encoder.writeDescribedType(frameBody);
        }
        if ((payloadSize = Math.min(payload == null ? 0 : payload.remaining(), this._maxFrameSize - (buffer.position() - oldPosition))) > 0) {
            int oldLimit = payload.limit();
            payload.limit(payload.position() + payloadSize);
            buffer.put(payload);
            payload.limit(oldLimit);
        }
        int frameSize = buffer.position() - oldPosition;
        int limit = buffer.position();
        buffer.position(oldPosition);
        buffer.putInt(frameSize);
        buffer.put((byte)2);
        buffer.put((byte)0);
        buffer.putShort((short)channel);
        buffer.position(limit);
        return frameSize;
    }

    @Override
    protected ConnectionImpl getConnectionImpl() {
        return this._connectionEndpoint;
    }

    @Override
    public void free() {
        super.free();
    }

    @Override
    public void handleOpen(Open open, Binary payload, Integer channel) {
        this.setRemoteState(EndpointState.ACTIVE);
        if (this._connectionEndpoint != null) {
            this._connectionEndpoint.handleOpen(open);
        } else {
            this._open = open;
        }
        if (open.getMaxFrameSize().longValue() > 0L && open.getMaxFrameSize().longValue() < (long)this._maxFrameSize) {
            this._maxFrameSize = (int)open.getMaxFrameSize().longValue();
        }
    }

    @Override
    public void handleBegin(Begin begin, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions[channel];
        if (transportSession == null) {
            SessionImpl session;
            if (begin.getRemoteChannel() == null) {
                session = this._connectionEndpoint.session();
                transportSession = this.getTransportState(session);
            } else {
                transportSession = this._localSessions[begin.getRemoteChannel().intValue()];
                session = transportSession.getSession();
            }
            transportSession.setRemoteChannel(channel);
            session.setRemoteState(EndpointState.ACTIVE);
            transportSession.setNextIncomingId(begin.getNextOutgoingId());
            this._remoteSessions[channel.intValue()] = transportSession;
        }
    }

    @Override
    public void handleAttach(Attach attach, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions[channel];
        if (transportSession != null) {
            SessionImpl session = transportSession.getSession();
            TransportLink transportLink = transportSession.getLinkFromRemoteHandle(attach.getHandle());
            LinkImpl link = null;
            if (transportLink == null) {
                transportLink = transportSession.resolveHalfOpenLink(attach.getName());
                if (transportLink == null) {
                    link = attach.getRole() ? session.sender(attach.getName()) : session.receiver(attach.getName());
                    transportLink = this.getTransportState(link);
                } else {
                    link = (LinkImpl)transportLink.getLink();
                }
                if (!attach.getRole()) {
                    transportLink.setDeliveryCount(attach.getInitialDeliveryCount());
                }
                link.setRemoteState(EndpointState.ACTIVE);
                link.setRemoteSource(attach.getSource());
                link.setRemoteTarget(attach.getTarget());
                link.setRemoteReceiverSettleMode(attach.getRcvSettleMode());
                link.setRemoteSenderSettleMode(attach.getSndSettleMode());
                transportLink.setName(attach.getName());
                transportLink.setRemoteHandle(attach.getHandle());
                transportSession.addLinkRemoteHandle(transportLink, attach.getHandle());
            }
        }
    }

    @Override
    public void handleFlow(Flow flow, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions[channel];
        if (transportSession != null) {
            transportSession.handleFlow(flow);
        }
    }

    @Override
    public void handleTransfer(Transfer transfer, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions[channel];
        if (transportSession != null) {
            transportSession.handleTransfer(transfer, payload);
        }
    }

    @Override
    public void handleDisposition(Disposition disposition, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions[channel];
        if (transportSession != null) {
            transportSession.handleDisposition(disposition);
        }
    }

    @Override
    public void handleDetach(Detach detach, Binary payload, Integer channel) {
        TransportLink transportLink;
        TransportSession transportSession = this._remoteSessions[channel];
        if (transportSession != null && (transportLink = transportSession.getLinkFromRemoteHandle(detach.getHandle())) != null) {
            Object link = transportLink.getLink();
            transportLink.receivedDetach();
            transportSession.freeRemoteHandle(transportLink.getRemoteHandle());
            ((EndpointImpl)link).setRemoteState(EndpointState.CLOSED);
        }
    }

    @Override
    public void handleEnd(End end, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions[channel];
        if (transportSession != null) {
            this._remoteSessions[channel.intValue()] = null;
            transportSession.receivedEnd();
            transportSession.getSession().setRemoteState(EndpointState.CLOSED);
        }
    }

    @Override
    public void handleClose(Close close, Binary payload, Integer channel) {
        this._closeReceived = true;
        this.setRemoteState(EndpointState.CLOSED);
        if (this._connectionEndpoint != null) {
            this._connectionEndpoint.setRemoteState(EndpointState.CLOSED);
        }
    }

    @Override
    public boolean input(TransportFrame frame) {
        if (this._protocolTracer != null) {
            this._protocolTracer.receivedFrame(frame);
        }
        if (this._connectionEndpoint != null || this.getRemoteState() == EndpointState.UNINITIALIZED) {
            frame.getBody().invoke(this, frame.getPayload(), frame.getChannel());
            return true;
        }
        return false;
    }

    public ProtocolTracer getProtocolTracer() {
        return this._protocolTracer;
    }

    public void setProtocolTracer(ProtocolTracer protocolTracer) {
        this._protocolTracer = protocolTracer;
    }

    static {
        TransportImpl.HEADER[0] = 65;
        TransportImpl.HEADER[1] = 77;
        TransportImpl.HEADER[2] = 81;
        TransportImpl.HEADER[3] = 80;
        TransportImpl.HEADER[4] = 0;
        TransportImpl.HEADER[5] = 1;
        TransportImpl.HEADER[6] = 0;
        TransportImpl.HEADER[7] = 0;
    }

    private static class PartialTransfer
    implements Runnable {
        private final Transfer _transfer;

        public PartialTransfer(Transfer transfer) {
            this._transfer = transfer;
        }

        @Override
        public void run() {
            this._transfer.setMore(true);
        }
    }
}

