/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.type.security;

import java.util.AbstractList;
import java.util.List;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DescribedTypeConstructor;
import org.apache.qpid.proton.type.Binary;
import org.apache.qpid.proton.type.DescribedType;
import org.apache.qpid.proton.type.Symbol;
import org.apache.qpid.proton.type.UnsignedLong;
import org.apache.qpid.proton.type.security.SaslFrameBody;

public class SaslInit
implements DescribedType,
SaslFrameBody {
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf(65L), Symbol.valueOf("amqp:sasl-init:list")};
    private static final UnsignedLong DESCRIPTOR = UnsignedLong.valueOf(65L);
    private final SaslInitWrapper _wrapper = new SaslInitWrapper();
    private Symbol _mechanism;
    private Binary _initialResponse;
    private String _hostname;

    public Symbol getMechanism() {
        return this._mechanism;
    }

    public void setMechanism(Symbol mechanism) {
        if (mechanism == null) {
            throw new NullPointerException("the mechanism field is mandatory");
        }
        this._mechanism = mechanism;
    }

    public Binary getInitialResponse() {
        return this._initialResponse;
    }

    public void setInitialResponse(Binary initialResponse) {
        this._initialResponse = initialResponse;
    }

    public String getHostname() {
        return this._hostname;
    }

    public void setHostname(String hostname) {
        this._hostname = hostname;
    }

    @Override
    public Object getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public Object getDescribed() {
        return this._wrapper;
    }

    public Object get(int index) {
        switch (index) {
            case 0: {
                return this._mechanism;
            }
            case 1: {
                return this._initialResponse;
            }
            case 2: {
                return this._hostname;
            }
        }
        throw new IllegalStateException("Unknown index " + index);
    }

    public int size() {
        return this._hostname != null ? 3 : (this._initialResponse != null ? 2 : 1);
    }

    public String toString() {
        return "SaslInit{mechanism=" + this._mechanism + ", initialResponse=" + this._initialResponse + ", hostname=" + (this._hostname == null ? "null" : '\'' + this._hostname + '\'') + '}';
    }

    @Override
    public <E> void invoke(SaslFrameBody.SaslFrameBodyHandler<E> handler, Binary payload, E context) {
        handler.handleInit(this, payload, context);
    }

    public static void register(Decoder decoder) {
        SaslInitConstructor constructor = new SaslInitConstructor();
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, constructor);
        }
    }

    private static class SaslInitConstructor
    implements DescribedTypeConstructor<SaslInit> {
        private SaslInitConstructor() {
        }

        @Override
        public SaslInit newInstance(Object described) {
            List l = (List)described;
            SaslInit o = new SaslInit();
            if (l.size() <= 0) {
                throw new DecodeException("The mechanism field cannot be omitted");
            }
            switch (3 - l.size()) {
                case 0: {
                    o.setHostname((String)l.get(2));
                }
                case 1: {
                    o.setInitialResponse((Binary)l.get(1));
                }
                case 2: {
                    o.setMechanism((Symbol)l.get(0));
                }
            }
            return o;
        }

        @Override
        public Class<SaslInit> getTypeClass() {
            return SaslInit.class;
        }
    }

    public final class SaslInitWrapper
    extends AbstractList {
        @Override
        public Object get(int index) {
            return SaslInit.this.get(index);
        }

        @Override
        public int size() {
            return SaslInit.this.size();
        }
    }
}

