/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.type.security;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DescribedTypeConstructor;
import org.apache.qpid.proton.type.Binary;
import org.apache.qpid.proton.type.DescribedType;
import org.apache.qpid.proton.type.Symbol;
import org.apache.qpid.proton.type.UnsignedLong;
import org.apache.qpid.proton.type.security.SaslFrameBody;

public class SaslMechanisms
implements DescribedType,
SaslFrameBody {
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf(64L), Symbol.valueOf("amqp:sasl-mechanisms:list")};
    private static final UnsignedLong DESCRIPTOR = UnsignedLong.valueOf(64L);
    private final SaslMechanismsWrapper _wrapper = new SaslMechanismsWrapper();
    private Symbol[] _saslServerMechanisms;

    public Symbol[] getSaslServerMechanisms() {
        return this._saslServerMechanisms;
    }

    public void setSaslServerMechanisms(Symbol ... saslServerMechanisms) {
        if (saslServerMechanisms == null) {
            throw new NullPointerException("the sasl-server-mechanisms field is mandatory");
        }
        this._saslServerMechanisms = saslServerMechanisms;
    }

    @Override
    public Object getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public Object getDescribed() {
        return this._wrapper;
    }

    public Object get(int index) {
        switch (index) {
            case 0: {
                return this._saslServerMechanisms;
            }
        }
        throw new IllegalStateException("Unknown index " + index);
    }

    public int size() {
        return 1;
    }

    @Override
    public <E> void invoke(SaslFrameBody.SaslFrameBodyHandler<E> handler, Binary payload, E context) {
        handler.handleMechanisms(this, payload, context);
    }

    public static void register(Decoder decoder) {
        SaslMechanismsConstructor constructor = new SaslMechanismsConstructor();
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, constructor);
        }
    }

    public String toString() {
        return "SaslMechanisms{saslServerMechanisms=" + (this._saslServerMechanisms == null ? null : Arrays.asList(this._saslServerMechanisms)) + '}';
    }

    private static class SaslMechanismsConstructor
    implements DescribedTypeConstructor<SaslMechanisms> {
        private SaslMechanismsConstructor() {
        }

        @Override
        public SaslMechanisms newInstance(Object described) {
            List l = (List)described;
            SaslMechanisms o = new SaslMechanisms();
            if (l.size() <= 0) {
                throw new DecodeException("The sasl-server-mechanisms field cannot be omitted");
            }
            switch (1 - l.size()) {
                case 0: {
                    Object val0 = l.get(0);
                    if (val0 == null || val0.getClass().isArray()) {
                        o.setSaslServerMechanisms((Symbol[])val0);
                        break;
                    }
                    o.setSaslServerMechanisms((Symbol)val0);
                }
            }
            return o;
        }

        @Override
        public Class<SaslMechanisms> getTypeClass() {
            return SaslMechanisms.class;
        }
    }

    public final class SaslMechanismsWrapper
    extends AbstractList {
        @Override
        public Object get(int index) {
            return SaslMechanisms.this.get(index);
        }

        @Override
        public int size() {
            return SaslMechanisms.this.size();
        }
    }
}

