/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.type.transport;

import java.util.AbstractList;
import java.util.List;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DescribedTypeConstructor;
import org.apache.qpid.proton.type.Binary;
import org.apache.qpid.proton.type.DescribedType;
import org.apache.qpid.proton.type.Symbol;
import org.apache.qpid.proton.type.UnsignedInteger;
import org.apache.qpid.proton.type.UnsignedLong;
import org.apache.qpid.proton.type.transport.DeliveryState;
import org.apache.qpid.proton.type.transport.FrameBody;

public class Disposition
implements DescribedType,
FrameBody {
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf(21L), Symbol.valueOf("amqp:disposition:list")};
    private static final UnsignedLong DESCRIPTOR = UnsignedLong.valueOf(21L);
    private final DispositionWrapper _wrapper = new DispositionWrapper();
    private boolean _role;
    private UnsignedInteger _first;
    private UnsignedInteger _last;
    private boolean _settled;
    private DeliveryState _state;
    private boolean _batchable;

    public boolean getRole() {
        return this._role;
    }

    public void setRole(boolean role) {
        this._role = role;
    }

    public UnsignedInteger getFirst() {
        return this._first;
    }

    public void setFirst(UnsignedInteger first) {
        if (first == null) {
            throw new NullPointerException("the first field is mandatory");
        }
        this._first = first;
    }

    public UnsignedInteger getLast() {
        return this._last;
    }

    public void setLast(UnsignedInteger last) {
        this._last = last;
    }

    public boolean getSettled() {
        return this._settled;
    }

    public void setSettled(boolean settled) {
        this._settled = settled;
    }

    public DeliveryState getState() {
        return this._state;
    }

    public void setState(DeliveryState state) {
        this._state = state;
    }

    public boolean getBatchable() {
        return this._batchable;
    }

    public void setBatchable(boolean batchable) {
        this._batchable = batchable;
    }

    @Override
    public Object getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public Object getDescribed() {
        return this._wrapper;
    }

    public Object get(int index) {
        switch (index) {
            case 0: {
                return this._role;
            }
            case 1: {
                return this._first;
            }
            case 2: {
                return this._last;
            }
            case 3: {
                return this._settled;
            }
            case 4: {
                return this._state;
            }
            case 5: {
                return this._batchable;
            }
        }
        throw new IllegalStateException("Unknown index " + index);
    }

    public int size() {
        return this._batchable ? 6 : (this._state != null ? 5 : (this._settled ? 4 : (this._last != null ? 3 : 2)));
    }

    @Override
    public <E> void invoke(FrameBody.FrameBodyHandler<E> handler, Binary payload, E context) {
        handler.handleDisposition(this, payload, context);
    }

    public static void register(Decoder decoder) {
        DispositionConstructor constructor = new DispositionConstructor();
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, constructor);
        }
    }

    public String toString() {
        return "Disposition{role=" + (this._role ? "RECIEVER" : "SENDER") + ", first=" + this._first + ", last=" + this._last + ", settled=" + this._settled + ", state=" + this._state + ", batchable=" + this._batchable + '}';
    }

    private static class DispositionConstructor
    implements DescribedTypeConstructor<Disposition> {
        private DispositionConstructor() {
        }

        @Override
        public Disposition newInstance(Object described) {
            List l = (List)described;
            Disposition o = new Disposition();
            if (l.size() <= 1) {
                throw new DecodeException("The first field cannot be omitted");
            }
            switch (6 - l.size()) {
                case 0: {
                    Boolean batchable = (Boolean)l.get(5);
                    o.setBatchable(batchable == null ? false : batchable);
                }
                case 1: {
                    o.setState((DeliveryState)l.get(4));
                }
                case 2: {
                    Boolean settled = (Boolean)l.get(3);
                    o.setSettled(settled == null ? false : settled);
                }
                case 3: {
                    o.setLast((UnsignedInteger)l.get(2));
                }
                case 4: {
                    o.setFirst((UnsignedInteger)l.get(1));
                }
                case 5: {
                    o.setRole((Boolean)l.get(0));
                }
            }
            return o;
        }

        @Override
        public Class<Disposition> getTypeClass() {
            return Disposition.class;
        }
    }

    public final class DispositionWrapper
    extends AbstractList {
        @Override
        public Object get(int index) {
            return Disposition.this.get(index);
        }

        @Override
        public int size() {
            return Disposition.this.size();
        }
    }
}

