/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.type.transport;

import java.util.AbstractList;
import java.util.List;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DescribedTypeConstructor;
import org.apache.qpid.proton.type.Binary;
import org.apache.qpid.proton.type.DescribedType;
import org.apache.qpid.proton.type.Symbol;
import org.apache.qpid.proton.type.UnsignedByte;
import org.apache.qpid.proton.type.UnsignedInteger;
import org.apache.qpid.proton.type.UnsignedLong;
import org.apache.qpid.proton.type.transport.DeliveryState;
import org.apache.qpid.proton.type.transport.FrameBody;

public class Transfer
implements DescribedType,
FrameBody {
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf(20L), Symbol.valueOf("amqp:transfer:list")};
    private static final UnsignedLong DESCRIPTOR = UnsignedLong.valueOf(20L);
    private final TransferWrapper _wrapper = new TransferWrapper();
    private UnsignedInteger _handle;
    private UnsignedInteger _deliveryId;
    private Binary _deliveryTag;
    private UnsignedInteger _messageFormat;
    private Boolean _settled;
    private boolean _more;
    private UnsignedByte _rcvSettleMode;
    private DeliveryState _state;
    private boolean _resume;
    private boolean _aborted;
    private boolean _batchable;

    public UnsignedInteger getHandle() {
        return this._handle;
    }

    public void setHandle(UnsignedInteger handle) {
        if (handle == null) {
            throw new NullPointerException("the handle field is mandatory");
        }
        this._handle = handle;
    }

    public UnsignedInteger getDeliveryId() {
        return this._deliveryId;
    }

    public void setDeliveryId(UnsignedInteger deliveryId) {
        this._deliveryId = deliveryId;
    }

    public Binary getDeliveryTag() {
        return this._deliveryTag;
    }

    public void setDeliveryTag(Binary deliveryTag) {
        this._deliveryTag = deliveryTag;
    }

    public UnsignedInteger getMessageFormat() {
        return this._messageFormat;
    }

    public void setMessageFormat(UnsignedInteger messageFormat) {
        this._messageFormat = messageFormat;
    }

    public Boolean getSettled() {
        return this._settled;
    }

    public void setSettled(Boolean settled) {
        this._settled = settled;
    }

    public boolean getMore() {
        return this._more;
    }

    public void setMore(boolean more) {
        this._more = more;
    }

    public UnsignedByte getRcvSettleMode() {
        return this._rcvSettleMode;
    }

    public void setRcvSettleMode(UnsignedByte rcvSettleMode) {
        this._rcvSettleMode = rcvSettleMode;
    }

    public DeliveryState getState() {
        return this._state;
    }

    public void setState(DeliveryState state) {
        this._state = state;
    }

    public boolean getResume() {
        return this._resume;
    }

    public void setResume(boolean resume) {
        this._resume = resume;
    }

    public boolean getAborted() {
        return this._aborted;
    }

    public void setAborted(boolean aborted) {
        this._aborted = aborted;
    }

    public boolean getBatchable() {
        return this._batchable;
    }

    public void setBatchable(boolean batchable) {
        this._batchable = batchable;
    }

    @Override
    public Object getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public Object getDescribed() {
        return this._wrapper;
    }

    public Object get(int index) {
        switch (index) {
            case 0: {
                return this._handle;
            }
            case 1: {
                return this._deliveryId;
            }
            case 2: {
                return this._deliveryTag;
            }
            case 3: {
                return this._messageFormat;
            }
            case 4: {
                return this._settled;
            }
            case 5: {
                return this._more;
            }
            case 6: {
                return this._rcvSettleMode;
            }
            case 7: {
                return this._state;
            }
            case 8: {
                return this._resume;
            }
            case 9: {
                return this._aborted;
            }
            case 10: {
                return this._batchable;
            }
        }
        throw new IllegalStateException("Unknown index " + index);
    }

    public int size() {
        return this._batchable ? 11 : (this._aborted ? 10 : (this._resume ? 9 : (this._state != null ? 8 : (this._rcvSettleMode != null ? 7 : (this._more ? 6 : (this._settled != null ? 5 : (this._messageFormat != null ? 4 : (this._deliveryTag != null ? 3 : (this._deliveryId != null ? 2 : 1)))))))));
    }

    @Override
    public <E> void invoke(FrameBody.FrameBodyHandler<E> handler, Binary payload, E context) {
        handler.handleTransfer(this, payload, context);
    }

    public static void register(Decoder decoder) {
        TransferConstructor constructor = new TransferConstructor();
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, constructor);
        }
    }

    public String toString() {
        return "Transfer{handle=" + this._handle + ", deliveryId=" + this._deliveryId + ", deliveryTag=" + this._deliveryTag + ", messageFormat=" + this._messageFormat + ", settled=" + this._settled + ", more=" + this._more + ", rcvSettleMode=" + this._rcvSettleMode + ", state=" + this._state + ", resume=" + this._resume + ", aborted=" + this._aborted + ", batchable=" + this._batchable + '}';
    }

    private static class TransferConstructor
    implements DescribedTypeConstructor<Transfer> {
        private TransferConstructor() {
        }

        @Override
        public Transfer newInstance(Object described) {
            List l = (List)described;
            Transfer o = new Transfer();
            if (l.size() <= 0) {
                throw new DecodeException("The handle field cannot be omitted");
            }
            switch (11 - l.size()) {
                case 0: {
                    Boolean batchable = (Boolean)l.get(10);
                    o.setBatchable(batchable == null ? false : batchable);
                }
                case 1: {
                    Boolean aborted = (Boolean)l.get(9);
                    o.setAborted(aborted == null ? false : aborted);
                }
                case 2: {
                    Boolean resume = (Boolean)l.get(8);
                    o.setResume(resume == null ? false : resume);
                }
                case 3: {
                    o.setState((DeliveryState)l.get(7));
                }
                case 4: {
                    o.setRcvSettleMode((UnsignedByte)l.get(6));
                }
                case 5: {
                    Boolean more = (Boolean)l.get(5);
                    o.setMore(more == null ? false : more);
                }
                case 6: {
                    o.setSettled((Boolean)l.get(4));
                }
                case 7: {
                    o.setMessageFormat((UnsignedInteger)l.get(3));
                }
                case 8: {
                    o.setDeliveryTag((Binary)l.get(2));
                }
                case 9: {
                    o.setDeliveryId((UnsignedInteger)l.get(1));
                }
                case 10: {
                    o.setHandle((UnsignedInteger)l.get(0));
                }
            }
            return o;
        }

        @Override
        public Class<Transfer> getTypeClass() {
            return Transfer.class;
        }
    }

    public final class TransferWrapper
    extends AbstractList {
        @Override
        public Object get(int index) {
            return Transfer.this.get(index);
        }

        @Override
        public int size() {
            return Transfer.this.size();
        }
    }
}

