/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.impl.dom.jaxp.DocumentBuilderFactoryImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.TrustException;
import org.apache.rahas.impl.util.SAML2KeyInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.util.Base64;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.KeyInfoConfirmationDataType;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class SAML2Utils {
    private static final Log log = LogFactory.getLog(SAML2Utils.class);

    public static Element getElementFromAssertion(XMLObject xmlObj) throws TrustException {
        try {
            String jaxpProperty = System.getProperty("javax.xml.parsers.DocumentBuilderFactory");
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            MarshallerFactory marshallerFactory = org.opensaml.xml.Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(xmlObj);
            Element element = marshaller.marshall(xmlObj);
            if (jaxpProperty == null) {
                System.getProperties().remove("javax.xml.parsers.DocumentBuilderFactory");
            } else {
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", jaxpProperty);
            }
            ByteArrayOutputStream byteArrayOutputStrm = new ByteArrayOutputStream();
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            LSOutput output = impl.createLSOutput();
            output.setByteStream(byteArrayOutputStrm);
            writer.write(element, output);
            String elementString = byteArrayOutputStrm.toString();
            DocumentBuilderFactoryImpl.setDOOMRequired((boolean)true);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(elementString.trim().getBytes()));
            Element assertionElement = document.getDocumentElement();
            DocumentBuilderFactoryImpl.setDOOMRequired((boolean)false);
            if (log.isDebugEnabled()) {
                log.debug((Object)"DOM element is created successfully from the OpenSAML2 XMLObject");
            }
            return assertionElement;
        }
        catch (Exception e) {
            throw new TrustException("Error creating DOM object from the assertion", e);
        }
    }

    public static SAML2KeyInfo getSAML2KeyInfo(Element elem, Crypto crypto, CallbackHandler cb) throws WSSecurityException {
        Assertion assertion;
        try {
            DefaultBootstrap.bootstrap();
            String keyInfoElementString = elem.toString();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(keyInfoElementString.trim().getBytes()));
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            assertion = (Assertion)unmarshaller.unmarshall(element);
        }
        catch (ConfigurationException e) {
            throw new WSSecurityException(0, "Failure in bootstrapping", null, (Throwable)e);
        }
        catch (UnmarshallingException e) {
            throw new WSSecurityException(0, "Failure in unmarshelling the assertion", null, (Throwable)e);
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "Failure in unmarshelling the assertion", null, (Throwable)e);
        }
        catch (SAXException e) {
            throw new WSSecurityException(0, "Failure in unmarshelling the assertion", null, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new WSSecurityException(0, "Failure in unmarshelling the assertion", null, (Throwable)e);
        }
        return SAML2Utils.getSAML2KeyInfo(assertion, crypto, cb);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SAML2KeyInfo getSAML2KeyInfo(Assertion assertion, Crypto crypto, CallbackHandler cb) throws WSSecurityException {
        byte[] key;
        WSPasswordCallback pwcb = new WSPasswordCallback(assertion.getID(), 7);
        if (cb != null) {
            try {
                cb.handle(new Callback[]{pwcb});
            }
            catch (Exception e1) {
                throw new WSSecurityException(0, "noKey", new Object[]{assertion.getID()}, (Throwable)e1);
            }
        }
        if ((key = pwcb.getKey()) != null) {
            return new SAML2KeyInfo(assertion, key);
        }
        try {
            AuthnStatement authnStmt;
            XMLObject KIElem;
            Subject samlSubject = assertion.getSubject();
            if (samlSubject == null) {
                throw new WSSecurityException(0, "invalidSAML2Token", new Object[]{"for Signature (no Subject)"});
            }
            SubjectConfirmation subjectConf = (SubjectConfirmation)samlSubject.getSubjectConfirmations().get(0);
            if (subjectConf == null) {
                throw new WSSecurityException(0, "invalidSAML2Token", new Object[]{"for Signature (no Subject Confirmation)"});
            }
            KeyInfoConfirmationDataType scData = (KeyInfoConfirmationDataType)subjectConf.getSubjectConfirmationData();
            if (scData == null) {
                throw new WSSecurityException(0, "invalidSAML2Token", new Object[]{"for Signature (no Subject Confirmation Data)"});
            }
            XMLObject xMLObject = KIElem = scData.getKeyInfos() != null ? (XMLObject)scData.getKeyInfos().get(0) : null;
            if (KIElem == null) throw new WSSecurityException(0, "invalidSAML2Token", new Object[]{"for Signature (no key info element)"});
            String jaxpProperty = System.getProperty("javax.xml.parsers.DocumentBuilderFactory");
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            MarshallerFactory marshallerFactory = org.opensaml.xml.Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(KIElem);
            Element keyInfoElement = marshaller.marshall(KIElem);
            if (jaxpProperty == null) {
                System.getProperties().remove("javax.xml.parsers.DocumentBuilderFactory");
            } else {
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", jaxpProperty);
            }
            AttributeStatement attrStmt = assertion.getAttributeStatements().size() != 0 ? (AttributeStatement)assertion.getAttributeStatements().get(0) : null;
            AuthnStatement authnStatement = authnStmt = assertion.getAuthnStatements().size() != 0 ? (AuthnStatement)assertion.getAuthnStatements().get(0) : null;
            if (attrStmt != null) {
                NodeList children = keyInfoElement.getChildNodes();
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    Node child = children.item(i);
                    if (child.getNodeType() != 1) continue;
                    QName el = new QName(child.getNamespaceURI(), child.getLocalName());
                    if (el.equals(WSSecurityEngine.ENCRYPTED_KEY)) {
                        EncryptedKeyProcessor proc = new EncryptedKeyProcessor();
                        proc.handleEncryptedKey((Element)child, cb, crypto, null);
                        return new SAML2KeyInfo(assertion, proc.getDecryptedBytes());
                    }
                    if (!el.equals(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "BinarySecret"))) continue;
                    Text txt = (Text)child.getFirstChild();
                    return new SAML2KeyInfo(assertion, Base64.decode((String)txt.getData()));
                }
                throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key "});
            } else {
                if (authnStmt == null) throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key "});
                X509Certificate[] certs = null;
                try {
                    KeyInfo ki = new KeyInfo(keyInfoElement, null);
                    if (!ki.containsX509Data()) throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key "});
                    X509Data data = ki.itemX509Data(0);
                    XMLX509Certificate certElem = null;
                    if (data != null && data.containsCertificate()) {
                        certElem = data.itemCertificate(0);
                    }
                    if (certElem == null) throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key "});
                    X509Certificate cert = certElem.getX509Certificate();
                    certs = new X509Certificate[]{cert};
                    return new SAML2KeyInfo(assertion, certs);
                }
                catch (XMLSecurityException e3) {
                    throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate (key holder)"}, (Throwable)e3);
                }
            }
        }
        catch (MarshallingException e) {
            throw new WSSecurityException(0, "Failed marshalling the SAML Assertion", null, (Throwable)e);
        }
    }
}

