/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hive.authorizer;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.ranger.authorization.hive.authorizer.HiveAccessType;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveResource;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;

public class RangerHiveAccessRequest
extends RangerAccessRequestImpl {
    private HiveAccessType accessType = HiveAccessType.NONE;

    public RangerHiveAccessRequest() {
    }

    public RangerHiveAccessRequest(RangerHiveResource resource, String user, Set<String> userGroups, String hiveOpTypeName, HiveAccessType accessType, HiveAuthzContext context, HiveAuthzSessionContext sessionContext) {
        this.setResource((RangerAccessResource)resource);
        this.setUser(user);
        this.setUserGroups(userGroups);
        this.setAccessTime(new Date());
        this.setAction(hiveOpTypeName);
        this.setHiveAccessType(accessType);
        if (context != null) {
            this.setRequestData(context.getCommandString());
            this.setForwardedAddresses(context.getForwardedAddresses());
            this.setRemoteIPAddress(context.getIpAddress());
        }
        if (sessionContext != null) {
            this.setClientType(sessionContext.getClientType() == null ? null : sessionContext.getClientType().toString());
            this.setSessionId(sessionContext.getSessionString());
        }
    }

    public RangerHiveAccessRequest(RangerHiveResource resource, String user, Set<String> userGroups, HiveOperationType hiveOpType, HiveAccessType accessType, HiveAuthzContext context, HiveAuthzSessionContext sessionContext) {
        this(resource, user, userGroups, hiveOpType.name(), accessType, context, sessionContext);
    }

    public RangerHiveAccessRequest(RangerHiveResource resource, String user, Set<String> groups, HiveAuthzContext context, HiveAuthzSessionContext sessionContext) {
        this(resource, user, groups, "METADATA OPERATION", HiveAccessType.USE, context, sessionContext);
    }

    public HiveAccessType getHiveAccessType() {
        return this.accessType;
    }

    public void setHiveAccessType(HiveAccessType accessType) {
        this.accessType = accessType;
        if (accessType == HiveAccessType.USE) {
            this.setAccessType("_any");
        } else if (accessType == HiveAccessType.ADMIN) {
            this.setAccessType("_admin");
        } else {
            this.setAccessType(accessType.name().toLowerCase());
        }
    }

    public RangerHiveAccessRequest copy() {
        RangerHiveAccessRequest ret = new RangerHiveAccessRequest();
        ret.setResource(this.getResource());
        ret.setAccessType(this.getAccessType());
        ret.setUser(this.getUser());
        ret.setUserGroups(this.getUserGroups());
        ret.setAccessTime(this.getAccessTime());
        ret.setAction(this.getAction());
        ret.setClientIPAddress(this.getClientIPAddress());
        ret.setRemoteIPAddress(this.getRemoteIPAddress());
        ret.setForwardedAddresses(this.getForwardedAddresses());
        ret.setRequestData(this.getRequestData());
        ret.setClientType(this.getClientType());
        ret.setSessionId(this.getSessionId());
        ret.setContext(RangerAccessRequestUtil.copyContext((Map)this.getContext()));
        ret.accessType = this.accessType;
        return ret;
    }
}

