/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hive.authorizer;

import org.apache.ranger.authorization.hive.authorizer.HiveObjectType;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;

public class RangerHiveResource
extends RangerAccessResourceImpl {
    public static final String KEY_DATABASE = "database";
    public static final String KEY_TABLE = "table";
    public static final String KEY_UDF = "udf";
    public static final String KEY_COLUMN = "column";
    private HiveObjectType objectType = null;

    public RangerHiveResource(HiveObjectType objectType, String database) {
        this(objectType, database, null, null);
    }

    public RangerHiveResource(HiveObjectType objectType, String database, String tableOrUdf) {
        this(objectType, database, tableOrUdf, null);
    }

    public RangerHiveResource(HiveObjectType objectType, String database, String tableOrUdf, String column) {
        this.objectType = objectType;
        switch (objectType) {
            case DATABASE: {
                this.setValue(KEY_DATABASE, database);
                break;
            }
            case FUNCTION: {
                this.setValue(KEY_DATABASE, database);
                this.setValue(KEY_UDF, tableOrUdf);
                break;
            }
            case COLUMN: {
                this.setValue(KEY_DATABASE, database);
                this.setValue(KEY_TABLE, tableOrUdf);
                this.setValue(KEY_COLUMN, column);
                break;
            }
            case TABLE: 
            case VIEW: 
            case INDEX: 
            case PARTITION: {
                this.setValue(KEY_DATABASE, database);
                this.setValue(KEY_TABLE, tableOrUdf);
                break;
            }
        }
    }

    public HiveObjectType getObjectType() {
        return this.objectType;
    }

    public String getDatabase() {
        return this.getValue(KEY_DATABASE);
    }

    public String getTable() {
        return this.getValue(KEY_TABLE);
    }

    public String getUdf() {
        return this.getValue(KEY_UDF);
    }

    public String getColumn() {
        return this.getValue(KEY_COLUMN);
    }
}

