/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hive.client;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.hive.client.HiveClient;

public class HiveConnectionMgr {
    private static Logger LOG = Logger.getLogger(HiveConnectionMgr.class);
    protected ConcurrentMap<String, HiveClient> hiveConnectionCache = new ConcurrentHashMap<String, HiveClient>();
    protected ConcurrentMap<String, Boolean> repoConnectStatusMap = new ConcurrentHashMap<String, Boolean>();

    public HiveClient getHiveConnection(final String serviceName, String serviceType, final Map<String, String> configs) {
        HiveClient hiveClient = null;
        if (serviceType != null) {
            hiveClient = (HiveClient)this.hiveConnectionCache.get(serviceName);
            if (hiveClient == null) {
                if (configs != null) {
                    Callable<HiveClient> connectHive = new Callable<HiveClient>(){

                        @Override
                        public HiveClient call() throws Exception {
                            return new HiveClient(serviceName, configs);
                        }
                    };
                    try {
                        hiveClient = (HiveClient)TimedEventUtil.timedTask((Callable)connectHive, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error connecting hive repository : " + serviceName + " using config : " + configs), (Throwable)e);
                    }
                    HiveClient oldClient = this.hiveConnectionCache.putIfAbsent(serviceName, hiveClient);
                    if (oldClient != null) {
                        hiveClient.close();
                        hiveClient = oldClient;
                    }
                    this.repoConnectStatusMap.put(serviceName, true);
                } else {
                    LOG.error((Object)("Connection Config not defined for asset :" + serviceName), new Throwable());
                }
            } else {
                try {
                    hiveClient.getDatabaseList("*", null);
                }
                catch (Exception e) {
                    this.hiveConnectionCache.remove(serviceName);
                    hiveClient.close();
                    hiveClient = this.getHiveConnection(serviceName, serviceType, configs);
                }
            }
        } else {
            LOG.error((Object)("Asset not found with name " + serviceName), new Throwable());
        }
        return hiveClient;
    }
}

