/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.ranger.plugin.model.AuditFilter;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyengine.RangerTagAccessRequest;
import org.apache.ranger.plugin.policyevaluator.RangerDefaultPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerDefaultPolicyItemEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuditPolicyEvaluator
extends RangerDefaultPolicyEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAuditPolicyEvaluator.class);
    private final RangerAuditPolicy auditPolicy;
    private final boolean matchAnyResource;
    private final List<RangerAuditPolicyItemEvaluator> auditItemEvaluators = new ArrayList<RangerAuditPolicyItemEvaluator>();

    public RangerAuditPolicyEvaluator(AuditFilter auditFilter, int priority) {
        this.auditPolicy = new RangerAuditPolicy(auditFilter, priority);
        this.matchAnyResource = MapUtils.isEmpty(auditFilter.getResources());
        if (LOG.isDebugEnabled()) {
            LOG.debug("RangerAuditPolicyEvaluator(auditFilter=" + auditFilter + ", priority=" + priority + ", matchAnyResource=" + this.matchAnyResource + ")");
        }
    }

    public RangerAuditPolicy getAuditPolicy() {
        return this.auditPolicy;
    }

    @Override
    public void init(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuditPolicyEvaluator.init(" + this.auditPolicy.getId() + ")");
        }
        super.init(this.auditPolicy, serviceDef, options);
        int policyItemIndex = 1;
        for (RangerAuditPolicyItem policyItem : this.auditPolicy.getAuditPolicyItems()) {
            RangerAuditPolicyItemEvaluator itemEvaluator = new RangerAuditPolicyItemEvaluator(serviceDef, this.auditPolicy, policyItem, policyItemIndex, options);
            this.auditItemEvaluators.add(itemEvaluator);
            ++policyItemIndex;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuditPolicyEvaluator.init(" + this.auditPolicy.getId() + ")");
        }
    }

    @Override
    public void evaluate(RangerAccessRequest request, RangerAccessResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuditPolicyEvaluator.evaluate(" + this.auditPolicy.getId() + ", " + request + ", " + result + ")");
        }
        if (request != null && result != null && !result.getIsAuditedDetermined() && this.matchResource(request)) {
            this.evaluatePolicyItems(request, result);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuditPolicyEvaluator.evaluate(" + this.auditPolicy.getId() + ", " + request + ", " + result + ")");
        }
    }

    @Override
    protected void preprocessPolicy(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        super.preprocessPolicy(policy, serviceDef, options);
        Map<String, Collection<String>> impliedAccessGrants = options.getServiceDefHelper().getImpliedAccessGrants();
        if (impliedAccessGrants == null || impliedAccessGrants.isEmpty()) {
            return;
        }
        this.preprocessPolicyItems(this.auditPolicy.getAuditPolicyItems(), impliedAccessGrants);
    }

    private boolean matchResource(RangerAccessRequest request) {
        boolean ret = false;
        if (!this.matchAnyResource) {
            for (RangerPolicyEvaluator.RangerPolicyResourceEvaluator resourceEvaluator : this.getResourceEvaluators()) {
                RangerPolicyResourceMatcher.MatchType matchType;
                if (RangerTagAccessRequest.class.isInstance(request)) {
                    matchType = ((RangerTagAccessRequest)request).getMatchType();
                    if (matchType == RangerPolicyResourceMatcher.MatchType.ANCESTOR) {
                        matchType = RangerPolicyResourceMatcher.MatchType.SELF;
                    }
                } else {
                    RangerPolicyResourceMatcher resourceMatcher = resourceEvaluator.getPolicyResourceMatcher();
                    matchType = resourceMatcher != null ? resourceMatcher.getMatchType(request.getResource(), request.getResourceElementMatchingScopes(), request.getContext()) : RangerPolicyResourceMatcher.MatchType.NONE;
                }
                if (request.isAccessTypeAny()) {
                    ret = matchType != RangerPolicyResourceMatcher.MatchType.NONE;
                } else if (request.getResourceMatchingScope() == RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS) {
                    ret = matchType != RangerPolicyResourceMatcher.MatchType.NONE;
                } else {
                    boolean bl = ret = matchType == RangerPolicyResourceMatcher.MatchType.SELF || matchType == RangerPolicyResourceMatcher.MatchType.SELF_AND_ALL_DESCENDANTS;
                }
                if (!ret) continue;
                break;
            }
        } else {
            ret = true;
        }
        return ret;
    }

    private void evaluatePolicyItems(RangerAccessRequest request, RangerAccessResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuditPolicyEvaluator.evaluatePolicyItems(" + this.auditPolicy.getId() + ", " + request + ", " + result + ")");
        }
        for (RangerAuditPolicyItemEvaluator itemEvaluator : this.auditItemEvaluators) {
            Boolean isAudited;
            if (!itemEvaluator.isMatch(request, result) || (isAudited = itemEvaluator.getIsAudited()) == null) continue;
            result.setIsAudited(isAudited);
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuditPolicyEvaluator.evaluatePolicyItems(" + this.auditPolicy.getId() + ", " + request + ", " + result + ")");
        }
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerAuditPolicyEvaluator={");
        super.toString(sb);
        sb.append("auditPolicy={");
        this.auditPolicy.toString(sb);
        sb.append("}");
        sb.append(" matchAnyResource={").append(this.matchAnyResource).append("}");
        sb.append("}");
        return sb;
    }

    public static class RangerAuditPolicyItem
    extends RangerPolicy.RangerPolicyItem {
        private final AuditFilter.AccessResult accessResult;
        private final Set<String> actions;
        private final Set<String> accessTypes;
        private final Boolean isAudited;

        public RangerAuditPolicyItem(AuditFilter auditFilter) {
            super(RangerAuditPolicyItem.getPolicyItemAccesses(auditFilter.getAccessTypes()), auditFilter.getUsers(), auditFilter.getGroups(), auditFilter.getRoles(), null, null);
            this.accessResult = auditFilter.getAccessResult();
            this.actions = auditFilter.getActions() != null ? new HashSet<String>(auditFilter.getActions()) : Collections.emptySet();
            this.accessTypes = auditFilter.getAccessTypes() != null ? new HashSet<String>(auditFilter.getAccessTypes()) : Collections.emptySet();
            this.isAudited = auditFilter.getIsAudited();
        }

        public Set<String> getActions() {
            return this.actions;
        }

        public Set<String> getAccessTypes() {
            return this.accessTypes;
        }

        public AuditFilter.AccessResult getAccessResult() {
            return this.accessResult;
        }

        public Boolean getIsAudited() {
            return this.isAudited;
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("RangerAuditPolicyItem={");
            super.toString(sb);
            sb.append(" accessResult={").append((Object)this.accessResult).append("}");
            sb.append(" actions={");
            if (this.actions != null) {
                for (String action : this.actions) {
                    if (action == null) continue;
                    sb.append(action).append(" ");
                }
            }
            sb.append("}");
            sb.append(" accessTypes={");
            if (this.accessTypes != null) {
                for (String accessTypes : this.accessTypes) {
                    if (accessTypes == null) continue;
                    sb.append(accessTypes).append(" ");
                }
            }
            sb.append("}");
            sb.append(" isAudited={").append(this.isAudited).append("}");
            sb.append("}");
            return sb;
        }

        private static List<RangerPolicy.RangerPolicyItemAccess> getPolicyItemAccesses(List<String> accessTypes) {
            List<RangerPolicy.RangerPolicyItemAccess> ret;
            if (accessTypes != null) {
                ret = new ArrayList<RangerPolicy.RangerPolicyItemAccess>(accessTypes.size());
                for (String accessType : accessTypes) {
                    ret.add(new RangerPolicy.RangerPolicyItemAccess(accessType));
                }
            } else {
                ret = Collections.emptyList();
            }
            return ret;
        }
    }

    public static class RangerAuditPolicy
    extends RangerPolicy {
        private final List<RangerAuditPolicyItem> auditPolicyItems;

        public RangerAuditPolicy(AuditFilter auditFilter, int priority) {
            this.setId(Long.valueOf(priority));
            this.setResources(auditFilter.getResources());
            this.setPolicyType(3);
            this.setPolicyPriority(priority);
            this.auditPolicyItems = Collections.singletonList(new RangerAuditPolicyItem(auditFilter));
        }

        public List<RangerAuditPolicyItem> getAuditPolicyItems() {
            return this.auditPolicyItems;
        }
    }

    public static class RangerAuditPolicyItemEvaluator
    extends RangerDefaultPolicyItemEvaluator {
        private final RangerAuditPolicyItem auditPolicyItem;
        private final boolean matchAnyResult;
        private final boolean matchAnyUser;
        private final boolean matchAnyAction;
        private final boolean hasResourceOwner;

        public RangerAuditPolicyItemEvaluator(RangerServiceDef serviceDef, RangerPolicy policy, RangerAuditPolicyItem policyItem, int policyItemIndex, RangerPolicyEngineOptions options) {
            super(serviceDef, policy, policyItem, 0, policyItemIndex, options);
            this.auditPolicyItem = policyItem;
            this.matchAnyResult = policyItem.getAccessResult() == null;
            List<String> users = policyItem.getUsers();
            List<String> groups = policyItem.getGroups();
            List<String> roles = policyItem.getRoles();
            this.matchAnyUser = CollectionUtils.isEmpty(users) && CollectionUtils.isEmpty(groups) && CollectionUtils.isEmpty(roles) || CollectionUtils.isNotEmpty(groups) && groups.contains("public") || CollectionUtils.isNotEmpty(users) && users.contains("{USER}");
            this.matchAnyAction = policyItem.getActions().isEmpty() && policyItem.getAccessTypes().isEmpty();
            boolean bl = this.hasResourceOwner = CollectionUtils.isNotEmpty(users) && users.contains("{OWNER}");
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerAuditPolicyItemEvaluator(" + this.auditPolicyItem + ", matchAnyUser=" + this.matchAnyUser + ", matchAnyAction=" + this.matchAnyAction + ", hasResourceOwner=" + this.hasResourceOwner + ")");
            }
        }

        public Boolean getIsAudited() {
            return this.auditPolicyItem.getIsAudited();
        }

        public boolean isMatch(RangerAccessRequest request, RangerAccessResult result) {
            boolean ret;
            boolean bl = ret = this.matchAccessResult(result) && this.matchUserGroupRole(request) && this.matchAction(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerAuditPolicyItemEvaluator.isMatch(" + request + ", " + result + "): ret=" + ret);
            }
            return ret;
        }

        private boolean matchAccessResult(RangerAccessResult result) {
            boolean ret = this.matchAnyResult;
            if (!ret) {
                switch (this.auditPolicyItem.getAccessResult()) {
                    case DENIED: {
                        ret = result.getIsAccessDetermined() && !result.getIsAllowed();
                        break;
                    }
                    case ALLOWED: {
                        ret = result.getIsAccessDetermined() && result.getIsAllowed();
                        break;
                    }
                    case NOT_DETERMINED: {
                        boolean bl = ret = !result.getIsAccessDetermined();
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerAuditPolicyItemEvaluator.matchAccessResult(" + result + "): ret=" + ret);
            }
            return ret;
        }

        private boolean matchUserGroupRole(RangerAccessRequest request) {
            boolean ret = this.matchAnyUser;
            if (!ret) {
                if (this.auditPolicyItem.getUsers() != null && request.getUser() != null && !(ret = this.auditPolicyItem.getUsers().contains(request.getUser())) && this.hasResourceOwner) {
                    String owner = request.getResource() != null ? request.getResource().getOwnerUser() : null;
                    ret = request.getUser().equals(owner);
                }
                if (!ret && this.auditPolicyItem.getGroups() != null && request.getUserGroups() != null) {
                    ret = CollectionUtils.containsAny(this.auditPolicyItem.getGroups(), request.getUserGroups());
                }
                if (!ret && this.auditPolicyItem.getRoles() != null) {
                    ret = CollectionUtils.containsAny(this.auditPolicyItem.getRoles(), RangerAccessRequestUtil.getCurrentUserRolesFromContext(request.getContext()));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerAuditPolicyItemEvaluator.matchUserGroupRole(" + request + "): ret=" + ret);
            }
            return ret;
        }

        private boolean matchAction(RangerAccessRequest request) {
            boolean ret = this.matchAnyAction;
            if (!ret) {
                if (request.getAction() != null) {
                    ret = this.auditPolicyItem.getActions().contains(request.getAction());
                }
                if (!ret && request.getAccessType() != null) {
                    ret = this.auditPolicyItem.getAccessTypes().contains(request.getAccessType());
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerAuditPolicyItemEvaluator.matchAction(" + request + "): ret=" + ret);
            }
            return ret;
        }
    }
}

