/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.local;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.inject.Inject;
import org.apache.reef.runtime.common.files.RuntimeClasspathProvider;
import org.apache.reef.util.Optional;

public final class LocalClasspathProvider
implements RuntimeClasspathProvider {
    private final List<String> classPathSuffix = Collections.unmodifiableList(new ArrayList<String>(LocalClasspathProvider.getFilteredClasspath()));

    @Inject
    LocalClasspathProvider() {
    }

    private static LinkedHashSet<String> getFilteredClasspath() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Optional<Path> javaHome = LocalClasspathProvider.getJavaHome();
        if (javaHome.isPresent()) {
            Path javaHomePath = (Path)javaHome.get();
            for (Path classPathEntry : LocalClasspathProvider.getClasspath()) {
                if (classPathEntry.startsWith(javaHomePath)) continue;
                result.add(LocalClasspathProvider.toAbsolutePathString(classPathEntry));
            }
        } else {
            for (Path classPathEntry : LocalClasspathProvider.getClasspath()) {
                result.add(LocalClasspathProvider.toAbsolutePathString(classPathEntry));
            }
        }
        return result;
    }

    private static Optional<Path> getJavaHome() {
        File javaHomeFile;
        Optional<String> javaHome = LocalClasspathProvider.getEnv("JAVA_HOME");
        if (javaHome.isPresent() && (javaHomeFile = new File((String)javaHome.get())).exists()) {
            return Optional.of((Object)javaHomeFile.toPath());
        }
        return Optional.empty();
    }

    private static Optional<String> getEnv(String envName) {
        return Optional.ofNullable((Object)System.getenv(envName));
    }

    private static LinkedHashSet<Path> getClasspath() {
        LinkedHashSet<Path> result = new LinkedHashSet<Path>();
        for (String classPathEntry : System.getProperty("java.class.path").split(File.pathSeparator)) {
            File file = new File(classPathEntry);
            if (!file.exists()) continue;
            result.add(file.toPath());
        }
        return result;
    }

    private static String toAbsolutePathString(Path path) {
        return path.toAbsolutePath().toString();
    }

    public List<String> getDriverClasspathPrefix() {
        return Collections.emptyList();
    }

    public List<String> getDriverClasspathSuffix() {
        return this.classPathSuffix;
    }

    public List<String> getEvaluatorClasspathPrefix() {
        return Collections.emptyList();
    }

    public List<String> getEvaluatorClasspathSuffix() {
        return this.classPathSuffix;
    }
}

