/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.local.client;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.runtime.common.client.api.JobSubmissionEvent;
import org.apache.reef.runtime.common.files.FileResource;
import org.apache.reef.runtime.common.files.FileType;
import org.apache.reef.runtime.common.files.REEFFileNames;
import org.apache.reef.runtime.local.client.FileSet;
import org.apache.reef.tang.formats.ConfigurationModule;
import org.apache.reef.tang.formats.OptionalParameter;

final class DriverFiles {
    private static final Logger LOG = Logger.getLogger(DriverFiles.class.getName());
    private final FileSet localFiles = new FileSet();
    private final FileSet localLibs = new FileSet();
    private final FileSet globalFiles = new FileSet();
    private final FileSet globalLibs = new FileSet();
    private final REEFFileNames fileNames;

    DriverFiles(REEFFileNames fileNames) {
        this.fileNames = fileNames;
    }

    public static DriverFiles fromJobSubmission(JobSubmissionEvent jobSubmissionEvent, REEFFileNames fileNames) throws IOException {
        File f;
        DriverFiles driverFiles = new DriverFiles(fileNames);
        for (FileResource frp : jobSubmissionEvent.getGlobalFileSet()) {
            f = new File(frp.getPath());
            if (frp.getType() == FileType.LIB) {
                driverFiles.addGlobalLib(f);
                continue;
            }
            driverFiles.addGlobalFile(f);
        }
        for (FileResource frp : jobSubmissionEvent.getLocalFileSet()) {
            f = new File(frp.getPath());
            if (frp.getType() == FileType.LIB) {
                driverFiles.addLocalLib(f);
                continue;
            }
            driverFiles.addLocalFile(f);
        }
        return driverFiles;
    }

    private void addLocalLib(File f) throws IOException {
        this.checkFile(f);
        this.localLibs.add(f);
    }

    private void addLocalFile(File f) throws IOException {
        this.checkFile(f);
        this.localFiles.add(f);
    }

    private void addGlobalFile(File f) throws IOException {
        this.checkFile(f);
        this.globalFiles.add(f);
    }

    private void addGlobalLib(File f) throws IOException {
        this.checkFile(f);
        this.globalLibs.add(f);
    }

    private void checkFile(File f) {
        if (this.globalLibs.containsFileWithName(f.getName())) {
            LOG.log(Level.FINEST, "Adding a file that is already part of the global libraries: {0}", f);
        }
        if (this.globalFiles.containsFileWithName(f.getName())) {
            LOG.log(Level.FINEST, "Adding a file that is already part of the global files: {0}", f);
        }
        if (this.localLibs.containsFileWithName(f.getName())) {
            LOG.log(Level.FINEST, "Adding a file that is already part of the local libraries: {0}", f);
        }
        if (this.localFiles.containsFileWithName(f.getName())) {
            LOG.log(Level.FINEST, "Adding a file that is already part of the local files: {0}", f);
        }
    }

    public void copyTo(File destinationFolder) throws IOException {
        if (!destinationFolder.exists() && !destinationFolder.mkdirs()) {
            LOG.log(Level.WARNING, "Failed to create [{0}]", destinationFolder.getAbsolutePath());
        }
        File reefFolder = new File(destinationFolder, this.fileNames.getREEFFolderName());
        File localFolder = new File(reefFolder, this.fileNames.getLocalFolderName());
        File globalFolder = new File(reefFolder, this.fileNames.getGlobalFolderName());
        if (!localFolder.exists() && !localFolder.mkdirs()) {
            LOG.log(Level.WARNING, "Failed to create [{0}]", localFolder.getAbsolutePath());
        }
        if (!globalFolder.exists() && !globalFolder.mkdirs()) {
            LOG.log(Level.WARNING, "Failed to create [{0}]", globalFolder.getAbsolutePath());
        }
        try {
            this.localFiles.createSymbolicLinkTo(localFolder);
            this.localLibs.createSymbolicLinkTo(localFolder);
            this.globalLibs.createSymbolicLinkTo(globalFolder);
            this.globalFiles.createSymbolicLinkTo(globalFolder);
        }
        catch (IOException e) {
            LOG.log(Level.FINE, "Can't symlink the files, copying them instead.", e);
            this.localFiles.copyTo(localFolder);
            this.localLibs.copyTo(localFolder);
            this.globalLibs.copyTo(globalFolder);
            this.globalFiles.copyTo(globalFolder);
        }
    }

    public ConfigurationModule addNamesTo(ConfigurationModule input, OptionalParameter<String> globalFileField, OptionalParameter<String> globalLibField, OptionalParameter<String> localFileField, OptionalParameter<String> localLibField) {
        ConfigurationModule result = input;
        result = this.globalFiles.addNamesTo(result, globalFileField);
        result = this.globalLibs.addNamesTo(result, globalLibField);
        result = this.localFiles.addNamesTo(result, localFileField);
        result = this.localLibs.addNamesTo(result, localLibField);
        return result;
    }
}

