/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.local.client;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.tang.formats.ConfigurationModule;
import org.apache.reef.tang.formats.OptionalParameter;

final class FileSet {
    private static final Logger LOG = Logger.getLogger(FileSet.class.getName());
    private final Set<File> theFiles = new HashSet<File>();
    private final Set<String> fileNames = new HashSet<String>();

    FileSet() {
    }

    void add(File file) {
        if (file.isFile()) {
            if (this.fileNames.contains(file.getName())) {
                LOG.log(Level.FINEST, "A file with this name has already been added: {0}", file.getName());
            } else {
                this.fileNames.add(file.getName());
                this.theFiles.add(file);
            }
        } else {
            LOG.log(Level.FINEST, "Ignoring, because it is not a proper file: {0}", file);
        }
    }

    boolean containsFileWithName(String name) {
        return this.fileNames.contains(name);
    }

    Set<String> fileNames() {
        return this.fileNames;
    }

    void copyTo(File destinationFolder) throws IOException {
        for (File f : this.theFiles) {
            File destinationFile = new File(destinationFolder, f.getName());
            Files.copy(f.toPath(), destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    void createSymbolicLinkTo(File destinationFolder) throws IOException {
        for (File f : this.theFiles) {
            File destinationFile = new File(destinationFolder, f.getName());
            Files.createSymbolicLink(destinationFile.toPath(), f.toPath(), new FileAttribute[0]);
        }
    }

    ConfigurationModule addNamesTo(ConfigurationModule input, OptionalParameter<String> field) {
        ConfigurationModule result = input;
        for (String fileName : this.fileNames()) {
            result = result.set(field, fileName);
        }
        return result;
    }
}

