/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.local.client;

import java.net.URI;
import java.util.Set;
import javax.inject.Inject;
import org.apache.reef.runtime.common.client.DriverConfigurationProvider;
import org.apache.reef.runtime.common.parameters.JVMHeapSlack;
import org.apache.reef.runtime.local.client.parameters.MaxNumberOfEvaluators;
import org.apache.reef.runtime.local.client.parameters.RackNames;
import org.apache.reef.runtime.local.driver.LocalDriverConfiguration;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Configurations;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.tang.formats.ConfigurationModule;

final class LocalDriverConfigurationProviderImpl
implements DriverConfigurationProvider {
    private final int maxEvaluators;
    private final double jvmHeapSlack;
    private final Set<String> rackNames;

    @Inject
    LocalDriverConfigurationProviderImpl(@Parameter(value=MaxNumberOfEvaluators.class) int maxEvaluators, @Parameter(value=JVMHeapSlack.class) double jvmHeapSlack, @Parameter(value=RackNames.class) Set<String> rackNames) {
        this.maxEvaluators = maxEvaluators;
        this.jvmHeapSlack = jvmHeapSlack;
        this.rackNames = rackNames;
    }

    private Configuration getDriverConfiguration(URI jobFolder, String clientRemoteId, String jobId) {
        ConfigurationModule configModule = LocalDriverConfiguration.CONF.set(LocalDriverConfiguration.MAX_NUMBER_OF_EVALUATORS, (Number)this.maxEvaluators).set(LocalDriverConfiguration.ROOT_FOLDER, jobFolder.getPath()).set(LocalDriverConfiguration.JVM_HEAP_SLACK, (Number)this.jvmHeapSlack).set(LocalDriverConfiguration.CLIENT_REMOTE_IDENTIFIER, clientRemoteId).set(LocalDriverConfiguration.JOB_IDENTIFIER, jobId).set(LocalDriverConfiguration.RUNTIME_NAMES, "Local");
        for (String rackName : this.rackNames) {
            configModule = configModule.set(LocalDriverConfiguration.RACK_NAMES, rackName);
        }
        return configModule.build();
    }

    public Configuration getDriverConfiguration(URI jobFolder, String clientRemoteId, String jobId, Configuration applicationConfiguration) {
        return Configurations.merge((Configuration[])new Configuration[]{this.getDriverConfiguration(jobFolder, clientRemoteId, jobId), applicationConfiguration});
    }
}

