/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.local.client;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.ClientSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.runtime.common.client.DriverConfigurationProvider;
import org.apache.reef.runtime.common.client.api.JobSubmissionEvent;
import org.apache.reef.runtime.common.client.api.JobSubmissionHandler;
import org.apache.reef.runtime.common.files.REEFFileNames;
import org.apache.reef.runtime.local.client.DriverFiles;
import org.apache.reef.runtime.local.client.PreparedDriverFolderLauncher;
import org.apache.reef.runtime.local.client.parameters.RootFolder;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.tang.formats.ConfigurationSerializer;
import org.apache.reef.util.logging.LoggingScope;
import org.apache.reef.util.logging.LoggingScopeFactory;

@Private
@ClientSide
final class LocalJobSubmissionHandler
implements JobSubmissionHandler {
    private static final Logger LOG = Logger.getLogger(LocalJobSubmissionHandler.class.getName());
    private final ExecutorService executor;
    private final String rootFolderName;
    private final ConfigurationSerializer configurationSerializer;
    private final REEFFileNames fileNames;
    private final PreparedDriverFolderLauncher driverLauncher;
    private final LoggingScopeFactory loggingScopeFactory;
    private final DriverConfigurationProvider driverConfigurationProvider;

    @Inject
    LocalJobSubmissionHandler(ExecutorService executor, @Parameter(value=RootFolder.class) String rootFolderName, ConfigurationSerializer configurationSerializer, REEFFileNames fileNames, PreparedDriverFolderLauncher driverLauncher, LoggingScopeFactory loggingScopeFactory, DriverConfigurationProvider driverConfigurationProvider) {
        this.executor = executor;
        this.configurationSerializer = configurationSerializer;
        this.fileNames = fileNames;
        this.driverLauncher = driverLauncher;
        this.driverConfigurationProvider = driverConfigurationProvider;
        this.rootFolderName = new File(rootFolderName).getAbsolutePath();
        this.loggingScopeFactory = loggingScopeFactory;
        LOG.log(Level.FINE, "Instantiated 'LocalJobSubmissionHandler'");
    }

    public void close() {
        this.executor.shutdown();
    }

    public void onNext(JobSubmissionEvent t) {
        try (LoggingScope lf = this.loggingScopeFactory.localJobSubmission();){
            try {
                LOG.log(Level.FINEST, "Starting local job {0}", t.getIdentifier());
                File jobFolder = new File(new File(this.rootFolderName), "/" + t.getIdentifier() + "-" + System.currentTimeMillis() + "/");
                File driverFolder = new File(jobFolder, "driver");
                if (!driverFolder.exists() && !driverFolder.mkdirs()) {
                    LOG.log(Level.WARNING, "Failed to create [{0}]", driverFolder.getAbsolutePath());
                }
                DriverFiles driverFiles = DriverFiles.fromJobSubmission(t, this.fileNames);
                driverFiles.copyTo(driverFolder);
                Configuration driverConfiguration = this.driverConfigurationProvider.getDriverConfiguration(jobFolder.toURI(), t.getRemoteId(), t.getIdentifier(), t.getConfiguration());
                this.configurationSerializer.toFile(driverConfiguration, new File(driverFolder, this.fileNames.getDriverConfigurationPath()));
                this.driverLauncher.launch(driverFolder);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Unable to setup driver.", e);
                throw new RuntimeException("Unable to setup driver.", e);
            }
        }
    }
}

