/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.local.client;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.reef.runtime.common.files.ClasspathProvider;
import org.apache.reef.runtime.common.files.REEFFileNames;
import org.apache.reef.runtime.common.launch.JavaLaunchCommandBuilder;
import org.apache.reef.runtime.common.launch.parameters.DriverLaunchCommandPrefix;
import org.apache.reef.runtime.local.process.LoggingRunnableProcessObserver;
import org.apache.reef.runtime.local.process.RunnableProcess;
import org.apache.reef.tang.annotations.Parameter;

public class PreparedDriverFolderLauncher {
    public static final String DRIVER_FOLDER_NAME = "driver";
    private final ExecutorService executor;
    private final REEFFileNames fileNames;
    private final ClasspathProvider classpath;
    private final List<String> commandPrefixList;
    public static final int DRIVER_MEMORY = 512;
    private static final Logger LOG = Logger.getLogger(PreparedDriverFolderLauncher.class.getName());

    @Inject
    PreparedDriverFolderLauncher(ExecutorService executor, REEFFileNames fileNames, @Parameter(value=DriverLaunchCommandPrefix.class) List<String> commandPrefixList, ClasspathProvider classpath) {
        this.executor = executor;
        this.fileNames = fileNames;
        this.classpath = classpath;
        this.commandPrefixList = commandPrefixList;
    }

    public void launch(File driverFolder) {
        this.launch(driverFolder, this.fileNames.getDriverStdoutFileName(), this.fileNames.getDriverStderrFileName());
    }

    public void launch(File driverFolder, String stdoutFilePath, String stderrFilePath) {
        assert (driverFolder.isDirectory());
        List<String> command = this.makeLaunchCommand();
        RunnableProcess process = new RunnableProcess(command, DRIVER_FOLDER_NAME, driverFolder, new LoggingRunnableProcessObserver(), stdoutFilePath, stderrFilePath);
        this.executor.submit(process);
        this.executor.shutdown();
    }

    private List<String> makeLaunchCommand() {
        List command = new JavaLaunchCommandBuilder(this.commandPrefixList).setConfigurationFilePaths(Collections.singletonList(this.fileNames.getDriverConfigurationPath())).setClassPath((Collection)this.classpath.getDriverClasspath()).setMemory(512).build();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "REEF app command: {0}", StringUtils.join((Collection)command, (char)' '));
        }
        return command;
    }
}

