/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.local.driver;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.lang.Validate;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.client.FailedRuntime;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.driver.api.ResourceRequestEvent;
import org.apache.reef.runtime.common.driver.api.RuntimeParameters;
import org.apache.reef.runtime.common.driver.resourcemanager.NodeDescriptorEvent;
import org.apache.reef.runtime.common.driver.resourcemanager.NodeDescriptorEventImpl;
import org.apache.reef.runtime.common.files.REEFFileNames;
import org.apache.reef.runtime.common.utils.RemoteManager;
import org.apache.reef.runtime.local.client.parameters.DefaultMemorySize;
import org.apache.reef.runtime.local.client.parameters.DefaultNumberOfCores;
import org.apache.reef.runtime.local.client.parameters.MaxNumberOfEvaluators;
import org.apache.reef.runtime.local.client.parameters.RackNames;
import org.apache.reef.runtime.local.client.parameters.RootFolder;
import org.apache.reef.runtime.local.driver.Container;
import org.apache.reef.runtime.local.driver.IDMaker;
import org.apache.reef.runtime.local.driver.ProcessContainer;
import org.apache.reef.runtime.local.process.ReefRunnableProcessObserver;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.util.CollectionUtils;
import org.apache.reef.util.MemoryUtils;
import org.apache.reef.util.Optional;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.remote.RemoteMessage;
import org.apache.reef.wake.remote.address.LocalAddressProvider;

@Private
@DriverSide
final class ContainerManager
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(ContainerManager.class.getName());
    private static final Collection<String> DEFAULT_RACKS = Arrays.asList("/default-rack");
    private final Map<String, Container> containers = new HashMap<String, Container>();
    private final Map<String, Map<String, Boolean>> freeNodesPerRack = new HashMap<String, Map<String, Boolean>>();
    private final Map<String, String> racksPerNode = new HashMap<String, String>();
    private final Map<String, Integer> capacitiesPerRack = new HashMap<String, Integer>();
    private final int capacity;
    private final int defaultMemorySize;
    private final int defaultNumberOfCores;
    private final String errorHandlerRID;
    private final EventHandler<NodeDescriptorEvent> nodeDescriptorHandler;
    private final File rootFolder;
    private final REEFFileNames fileNames;
    private final ReefRunnableProcessObserver processObserver;
    private final String localAddress;
    private final Collection<String> availableRacks;

    @Inject
    ContainerManager(RemoteManager remoteManager, REEFFileNames fileNames, @Parameter(value=MaxNumberOfEvaluators.class) int capacity, @Parameter(value=RootFolder.class) String rootFolderName, @Parameter(value=RuntimeParameters.NodeDescriptorHandler.class) EventHandler<NodeDescriptorEvent> nodeDescriptorHandler, @Parameter(value=RackNames.class) Set<String> rackNames, ReefRunnableProcessObserver processObserver, LocalAddressProvider localAddressProvider, @Parameter(value=DefaultMemorySize.class) int defaultMemorySize, @Parameter(value=DefaultNumberOfCores.class) int defaultNumberOfCores) {
        this.capacity = capacity;
        this.defaultMemorySize = defaultMemorySize;
        this.defaultNumberOfCores = defaultNumberOfCores;
        this.fileNames = fileNames;
        this.processObserver = processObserver;
        this.errorHandlerRID = remoteManager.getMyIdentifier();
        this.nodeDescriptorHandler = nodeDescriptorHandler;
        this.rootFolder = new File(rootFolderName);
        this.localAddress = localAddressProvider.getLocalAddress();
        this.availableRacks = this.normalize(rackNames);
        LOG.log(Level.FINEST, "Initializing Container Manager with {0} containers", capacity);
        remoteManager.registerHandler(ReefServiceProtos.RuntimeErrorProto.class, (EventHandler)new EventHandler<RemoteMessage<ReefServiceProtos.RuntimeErrorProto>>(){

            public void onNext(RemoteMessage<ReefServiceProtos.RuntimeErrorProto> value) {
                FailedRuntime error = new FailedRuntime((ReefServiceProtos.RuntimeErrorProto)value.getMessage());
                LOG.log(Level.SEVERE, "FailedRuntime: " + error, (Throwable)error.getReason().orElse(null));
                ContainerManager.this.release(error.getId());
            }
        });
        this.init();
        LOG.log(Level.FINE, "Initialized Container Manager with {0} containers", capacity);
    }

    private Collection<String> normalize(Collection<String> rackNames) {
        return this.normalize(rackNames, true);
    }

    private Collection<String> normalize(Collection<String> rackNames, boolean validateEnd) {
        ArrayList<String> normalizedRackNames = new ArrayList<String>(rackNames.size());
        Iterator<String> it = rackNames.iterator();
        while (it.hasNext()) {
            String rackName = it.next().trim();
            Validate.notEmpty((String)rackName, (String)"Rack names cannot be empty");
            if (!rackName.startsWith("/")) {
                rackName = "/" + rackName;
            }
            if (rackName.endsWith("/")) {
                rackName = rackName.substring(0, rackName.length() - 1);
            }
            if (validateEnd) {
                Validate.isTrue((!rackName.endsWith("*") ? 1 : 0) != 0);
            }
            normalizedRackNames.add(rackName);
        }
        return normalizedRackNames;
    }

    private void init() {
        int capacityPerRack = this.capacity / this.availableRacks.size();
        int missing = this.capacity % this.availableRacks.size();
        for (String rackName : this.availableRacks) {
            this.freeNodesPerRack.put(rackName, new HashMap());
            this.capacitiesPerRack.put(rackName, capacityPerRack);
            if (missing <= 0) continue;
            this.capacitiesPerRack.put(rackName, this.capacitiesPerRack.get(rackName) + 1);
            --missing;
        }
    }

    synchronized void start() {
        this.sendNodeDescriptors();
    }

    private void sendNodeDescriptors() {
        IDMaker idmaker = new IDMaker("Node-");
        int j = 0;
        for (String rackName : this.availableRacks) {
            int rackCapacity = this.capacitiesPerRack.get(rackName);
            for (int i = 0; i < rackCapacity; ++i) {
                String id = idmaker.getNextID();
                this.racksPerNode.put(id, rackName);
                this.freeNodesPerRack.get(rackName).put(id, Boolean.TRUE);
                int totalMemorySizeInMB = MemoryUtils.getTotalPhysicalMemorySizeInMB();
                int nodeMemorySizeInMB = -1 == totalMemorySizeInMB ? this.defaultMemorySize : totalMemorySizeInMB;
                this.nodeDescriptorHandler.onNext((Object)NodeDescriptorEventImpl.newBuilder().setIdentifier(id).setRackName(rackName).setHostName(this.localAddress).setPort(j).setMemorySize(nodeMemorySizeInMB).build());
                ++j;
            }
        }
    }

    private Collection<String> getRackNamesOrDefault(List<String> rackNames) {
        return CollectionUtils.isNotEmpty(rackNames) ? this.normalize(rackNames, false) : DEFAULT_RACKS;
    }

    private Optional<String> getPreferredNode(List<String> nodeNames) {
        if (CollectionUtils.isNotEmpty(nodeNames)) {
            for (String nodeName : nodeNames) {
                String possibleRack = this.racksPerNode.get(nodeName);
                if (possibleRack == null || !this.freeNodesPerRack.get(possibleRack).containsKey(nodeName)) continue;
                return Optional.of((Object)nodeName);
            }
        }
        return Optional.empty();
    }

    private Optional<String> getPreferredRack(List<String> rackNames) {
        Collection<String> normalized = this.getRackNamesOrDefault(rackNames);
        for (String rackName : normalized) {
            if (!rackName.endsWith("*")) {
                if (!this.freeNodesPerRack.containsKey(rackName) || this.freeNodesPerRack.get(rackName).size() <= 0) continue;
                return Optional.of((Object)rackName);
            }
            for (String possibleRackName : this.availableRacks) {
                String newRackName;
                if (!possibleRackName.startsWith(newRackName = rackName.substring(0, rackName.length() - 1)) || this.freeNodesPerRack.get(possibleRackName).size() <= 0) continue;
                return Optional.of((Object)possibleRackName);
            }
        }
        return Optional.empty();
    }

    Optional<Container> allocateContainer(ResourceRequestEvent requestEvent) {
        Container container = null;
        Optional<String> nodeName = this.getPreferredNode(requestEvent.getNodeNameList());
        if (nodeName.isPresent()) {
            container = this.allocateBasedOnNode((Integer)requestEvent.getMemorySize().orElse((Object)this.defaultMemorySize), (Integer)requestEvent.getVirtualCores().orElse((Object)this.defaultNumberOfCores), (String)nodeName.get());
        } else {
            Optional<String> rackName = this.getPreferredRack(requestEvent.getRackNameList());
            if (rackName.isPresent()) {
                container = this.allocateBasedOnRack((Integer)requestEvent.getMemorySize().orElse((Object)this.defaultMemorySize), (Integer)requestEvent.getVirtualCores().orElse((Object)this.defaultNumberOfCores), (String)rackName.get());
            }
        }
        return Optional.ofNullable(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Container allocateBasedOnNode(int megaBytes, int numberOfCores, String nodeId) {
        Map<String, Container> map = this.containers;
        synchronized (map) {
            String rackName = this.racksPerNode.get(nodeId);
            this.freeNodesPerRack.get(rackName).remove(nodeId);
            return this.allocate(megaBytes, numberOfCores, nodeId, rackName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Container allocateBasedOnRack(int megaBytes, int numberOfCores, String rackName) {
        Map<String, Container> map = this.containers;
        synchronized (map) {
            Set<String> freeNodes = this.freeNodesPerRack.get(rackName).keySet();
            Iterator<String> it = freeNodes.iterator();
            if (!it.hasNext()) {
                throw new IllegalArgumentException("There should be a free node in the specified rack " + rackName);
            }
            String nodeId = it.next();
            this.freeNodesPerRack.get(rackName).remove(nodeId);
            return this.allocate(megaBytes, numberOfCores, nodeId, rackName);
        }
    }

    private Container allocate(int megaBytes, int numberOfCores, String nodeId, String rackName) {
        String processID = nodeId + "-" + String.valueOf(System.currentTimeMillis());
        File processFolder = new File(this.rootFolder, processID);
        if (!processFolder.exists() && !processFolder.mkdirs()) {
            LOG.log(Level.WARNING, "Failed to create [{0}]", processFolder.getAbsolutePath());
        }
        ProcessContainer container = new ProcessContainer(this.errorHandlerRID, nodeId, processID, processFolder, megaBytes, numberOfCores, rackName, this.fileNames, this.processObserver);
        this.containers.put(container.getContainerID(), container);
        LOG.log(Level.FINE, "Allocated {0}", container.getContainerID());
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(String containerID) {
        Map<String, Container> map = this.containers;
        synchronized (map) {
            Container ctr = this.containers.get(containerID);
            if (null != ctr) {
                LOG.log(Level.INFO, "Releasing Container with containerId [{0}]", ctr);
                if (ctr.isRunning()) {
                    ctr.close();
                }
                this.freeNodesPerRack.get(ctr.getRackName()).put(ctr.getNodeID(), Boolean.TRUE);
                this.containers.remove(ctr.getContainerID());
            } else {
                LOG.log(Level.INFO, "Ignoring release request for unknown containerID [{0}]", containerID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Container get(String containedID) {
        Map<String, Container> map = this.containers;
        synchronized (map) {
            return this.containers.get(containedID);
        }
    }

    Iterable<String> getAllocatedContainerIDs() {
        return this.containers.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        Map<String, Container> map = this.containers;
        synchronized (map) {
            if (this.containers.isEmpty()) {
                LOG.log(Level.FINEST, "Clean shutdown with no outstanding containers.");
            } else {
                LOG.log(Level.WARNING, "Dirty shutdown with outstanding containers.");
                for (Container c : this.containers.values()) {
                    LOG.log(Level.WARNING, "Force shutdown of: {0}", c);
                    c.close();
                }
            }
        }
    }
}

