/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.local.driver;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.annotations.audience.TaskSide;
import org.apache.reef.runtime.common.files.REEFFileNames;
import org.apache.reef.runtime.local.driver.Container;
import org.apache.reef.runtime.local.process.ReefRunnableProcessObserver;
import org.apache.reef.runtime.local.process.RunnableProcess;
import org.apache.reef.runtime.local.process.RunnableProcessObserver;

@Private
@TaskSide
final class ProcessContainer
implements Container {
    private static final Logger LOG = Logger.getLogger(ProcessContainer.class.getName());
    private final String errorHandlerRID;
    private final String nodeID;
    private final File folder;
    private final String containedID;
    private final int megaBytes;
    private final int numberOfCores;
    private final String rackName;
    private final REEFFileNames fileNames;
    private final File reefFolder;
    private final File localFolder;
    private final File globalFolder;
    private final RunnableProcessObserver processObserver;
    private Thread theThread;
    private RunnableProcess process;

    ProcessContainer(String errorHandlerRID, String nodeID, String containedID, File folder, int megaBytes, int numberOfCores, String rackName, REEFFileNames fileNames, ReefRunnableProcessObserver processObserver) {
        this.errorHandlerRID = errorHandlerRID;
        this.nodeID = nodeID;
        this.containedID = containedID;
        this.folder = folder;
        this.megaBytes = megaBytes;
        this.numberOfCores = numberOfCores;
        this.rackName = rackName;
        this.fileNames = fileNames;
        this.processObserver = processObserver;
        this.reefFolder = new File(folder, fileNames.getREEFFolderName());
        this.localFolder = new File(this.reefFolder, fileNames.getLocalFolderName());
        if (!this.localFolder.exists() && !this.localFolder.mkdirs()) {
            LOG.log(Level.WARNING, "Failed to create [{0}]", this.localFolder.getAbsolutePath());
        }
        this.globalFolder = new File(this.reefFolder, fileNames.getGlobalFolderName());
        if (!this.globalFolder.exists() && !this.globalFolder.mkdirs()) {
            LOG.log(Level.WARNING, "Failed to create [{0}]", this.globalFolder.getAbsolutePath());
        }
    }

    private static void copy(Iterable<File> files, File folder) throws IOException {
        for (File sourceFile : files) {
            File destinationFile = new File(folder, sourceFile.getName());
            if (Files.isSymbolicLink(sourceFile.toPath())) {
                Path linkTargetPath = Files.readSymbolicLink(sourceFile.toPath());
                Files.createSymbolicLink(destinationFile.toPath(), linkTargetPath, new FileAttribute[0]);
                continue;
            }
            Files.copy(sourceFile.toPath(), destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @Override
    public void addLocalFiles(Iterable<File> files) {
        try {
            ProcessContainer.copy(files, this.localFolder);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to copy files to the evaluator folder.", e);
        }
    }

    @Override
    public void addGlobalFiles(File globalFolder) {
        try {
            File[] files = globalFolder.listFiles();
            if (files != null) {
                ProcessContainer.copy(Arrays.asList(files), this.globalFolder);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to copy files to the evaluator folder.", e);
        }
    }

    @Override
    public void run(List<String> commandLine) {
        this.process = new RunnableProcess(commandLine, this.containedID, this.folder, this.processObserver, this.fileNames.getEvaluatorStdoutFileName(), this.fileNames.getEvaluatorStderrFileName());
        this.theThread = new Thread(this.process);
        this.theThread.start();
    }

    @Override
    public boolean isRunning() {
        return null != this.theThread && this.theThread.isAlive();
    }

    @Override
    public int getMemory() {
        return this.megaBytes;
    }

    @Override
    public int getNumberOfCores() {
        return this.numberOfCores;
    }

    @Override
    public String getRackName() {
        return this.rackName;
    }

    @Override
    public File getFolder() {
        return this.folder;
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public String getContainerID() {
        return this.containedID;
    }

    @Override
    public void close() {
        if (this.isRunning()) {
            LOG.log(Level.WARNING, "Force-closing a container that is still running: {0}", this);
            this.process.cancel();
        }
    }

    public String toString() {
        return "ProcessContainer{containedID='" + this.containedID + '\'' + ", nodeID='" + this.nodeID + '\'' + ", errorHandlerRID='" + this.errorHandlerRID + '\'' + ", folder=" + this.folder + '\'' + ", rack=" + this.rackName + '}';
    }
}

