/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.local.driver;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.driver.evaluator.EvaluatorProcess;
import org.apache.reef.runtime.common.driver.api.ResourceLaunchEvent;
import org.apache.reef.runtime.common.driver.api.ResourceReleaseEvent;
import org.apache.reef.runtime.common.driver.api.ResourceRequestEvent;
import org.apache.reef.runtime.common.driver.api.RuntimeParameters;
import org.apache.reef.runtime.common.driver.evaluator.pojos.State;
import org.apache.reef.runtime.common.driver.resourcemanager.ResourceAllocationEvent;
import org.apache.reef.runtime.common.driver.resourcemanager.ResourceEventImpl;
import org.apache.reef.runtime.common.driver.resourcemanager.RuntimeStatusEvent;
import org.apache.reef.runtime.common.driver.resourcemanager.RuntimeStatusEventImpl;
import org.apache.reef.runtime.common.files.FileResource;
import org.apache.reef.runtime.common.files.REEFFileNames;
import org.apache.reef.runtime.common.parameters.JVMHeapSlack;
import org.apache.reef.runtime.common.utils.RemoteManager;
import org.apache.reef.runtime.local.driver.Container;
import org.apache.reef.runtime.local.driver.ContainerManager;
import org.apache.reef.runtime.local.driver.ResourceRequest;
import org.apache.reef.runtime.local.driver.ResourceRequestQueue;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.formats.ConfigurationSerializer;
import org.apache.reef.util.Optional;
import org.apache.reef.util.logging.LoggingScope;
import org.apache.reef.util.logging.LoggingScopeFactory;
import org.apache.reef.wake.EventHandler;

@Private
@DriverSide
public final class ResourceManager {
    private static final Logger LOG = Logger.getLogger(ResourceManager.class.getName());
    private final ResourceRequestQueue requestQueue = new ResourceRequestQueue();
    private final EventHandler<ResourceAllocationEvent> allocationHandler;
    private final ContainerManager theContainers;
    private final EventHandler<RuntimeStatusEvent> runtimeStatusHandlerEventHandler;
    private final ConfigurationSerializer configurationSerializer;
    private final RemoteManager remoteManager;
    private final REEFFileNames fileNames;
    private final double jvmHeapFactor;
    private final LoggingScopeFactory loggingScopeFactory;

    @Inject
    ResourceManager(ContainerManager containerManager, @Parameter(value=RuntimeParameters.ResourceAllocationHandler.class) EventHandler<ResourceAllocationEvent> allocationHandler, @Parameter(value=RuntimeParameters.RuntimeStatusHandler.class) EventHandler<RuntimeStatusEvent> runtimeStatusHandlerEventHandler, @Parameter(value=JVMHeapSlack.class) double jvmHeapSlack, ConfigurationSerializer configurationSerializer, RemoteManager remoteManager, REEFFileNames fileNames, LoggingScopeFactory loggingScopeFactory) {
        this.theContainers = containerManager;
        this.allocationHandler = allocationHandler;
        this.runtimeStatusHandlerEventHandler = runtimeStatusHandlerEventHandler;
        this.configurationSerializer = configurationSerializer;
        this.remoteManager = remoteManager;
        this.fileNames = fileNames;
        this.jvmHeapFactor = 1.0 - jvmHeapSlack;
        this.loggingScopeFactory = loggingScopeFactory;
        LOG.log(Level.FINE, "Instantiated 'ResourceManager'");
    }

    private static List<File> getLocalFiles(ResourceLaunchEvent launchRequest) {
        ArrayList<File> files = new ArrayList<File>();
        for (FileResource frp : launchRequest.getFileSet()) {
            files.add(new File(frp.getPath()).getAbsoluteFile());
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onResourceRequest(ResourceRequestEvent resourceRequest) {
        ContainerManager containerManager = this.theContainers;
        synchronized (containerManager) {
            this.requestQueue.add(new ResourceRequest(resourceRequest));
            this.checkRequestQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onResourceReleaseRequest(ResourceReleaseEvent releaseRequest) {
        ContainerManager containerManager = this.theContainers;
        synchronized (containerManager) {
            LOG.log(Level.FINEST, "Release container: {0}", releaseRequest.getIdentifier());
            this.theContainers.release(releaseRequest.getIdentifier());
            this.checkRequestQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvaluatorExit(String evaluatorId) {
        ContainerManager containerManager = this.theContainers;
        synchronized (containerManager) {
            this.theContainers.release(evaluatorId);
            this.checkRequestQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onResourceLaunchRequest(ResourceLaunchEvent launchRequest) {
        ContainerManager containerManager = this.theContainers;
        synchronized (containerManager) {
            Container c = this.theContainers.get(launchRequest.getIdentifier());
            try (LoggingScope lb = this.loggingScopeFactory.getNewLoggingScope("ResourceManager.onResourceLaunchRequest:evaluatorConfigurationFile");){
                c.addGlobalFiles(this.fileNames.getGlobalFolder());
                c.addLocalFiles(ResourceManager.getLocalFiles(launchRequest));
                File evaluatorConfigurationFile = new File(c.getFolder(), this.fileNames.getEvaluatorConfigurationPath());
                try {
                    this.configurationSerializer.toFile(launchRequest.getEvaluatorConf(), evaluatorConfigurationFile);
                }
                catch (IOException | BindException e) {
                    throw new RuntimeException("Unable to write configuration.", e);
                }
            }
            var5_5 = null;
            try (LoggingScope lc = this.loggingScopeFactory.getNewLoggingScope("ResourceManager.onResourceLaunchRequest:runCommand");){
                List<String> command = this.getLaunchCommand(launchRequest, c.getMemory());
                LOG.log(Level.FINEST, "Launching container: {0}", c);
                c.run(command);
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
        }
    }

    private List<String> getLaunchCommand(ResourceLaunchEvent launchRequest, int containerMemory) {
        EvaluatorProcess process = launchRequest.getProcess().setConfigurationFileName(this.fileNames.getEvaluatorConfigurationPath());
        if (process.isOptionSet()) {
            return process.getCommandLine();
        }
        return process.setMemory((int)(this.jvmHeapFactor * (double)containerMemory)).getCommandLine();
    }

    private void checkRequestQueue() {
        if (this.requestQueue.hasOutStandingRequests()) {
            ResourceRequest resourceRequest = this.requestQueue.head();
            ResourceRequestEvent requestEvent = resourceRequest.getRequestProto();
            Optional<Container> cont = this.theContainers.allocateContainer(requestEvent);
            if (cont.isPresent()) {
                this.requestQueue.satisfyOne();
                Container container = (Container)cont.get();
                ResourceEventImpl alloc = ResourceEventImpl.newAllocationBuilder().setIdentifier(container.getContainerID()).setNodeId(container.getNodeID()).setResourceMemory(container.getMemory()).setVirtualCores(container.getNumberOfCores()).setRackName(container.getRackName()).setRuntimeName("Local").build();
                LOG.log(Level.FINEST, "Allocating container: {0}", container);
                this.allocationHandler.onNext((Object)alloc);
                this.sendRuntimeStatus();
                this.checkRequestQueue();
            } else {
                this.sendRuntimeStatus();
            }
        } else {
            this.sendRuntimeStatus();
        }
    }

    private void sendRuntimeStatus() {
        RuntimeStatusEventImpl.Builder builder = RuntimeStatusEventImpl.newBuilder().setName("LOCAL").setState(State.RUNNING).setOutstandingContainerRequests(this.requestQueue.getNumberOfOutstandingRequests());
        for (String containerAllocation : this.theContainers.getAllocatedContainerIDs()) {
            builder.addContainerAllocation(containerAllocation);
        }
        RuntimeStatusEvent msg = builder.build();
        LOG.log(Level.INFO, "Allocated: {0}, Outstanding requests: {1}", new Object[]{msg.getContainerAllocationList().size(), msg.getOutstandingContainerRequests()});
        this.runtimeStatusHandlerEventHandler.onNext((Object)msg);
    }
}

