/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.local.driver;

import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.runtime.common.driver.api.ResourceRequestEvent;

@Private
@DriverSide
final class ResourceRequest {
    private final ResourceRequestEvent req;
    private int satisfied = 0;

    ResourceRequest(ResourceRequestEvent req) {
        if (null == req) {
            throw new IllegalArgumentException("Can't instantiate a ResourceRequest without a ResourceRequestEvent");
        }
        this.req = req;
    }

    void satisfyOne() {
        ++this.satisfied;
        if (this.satisfied > this.req.getResourceCount()) {
            throw new IllegalStateException("This request has been oversatisfied.");
        }
    }

    boolean isSatisfied() {
        return this.satisfied == this.req.getResourceCount();
    }

    ResourceRequestEvent getRequestProto() {
        return this.req;
    }
}

