/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.local.driver;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.runtime.common.driver.api.ResourceRequestEvent;
import org.apache.reef.runtime.local.driver.ResourceRequest;

@Private
@DriverSide
final class ResourceRequestQueue {
    private final BlockingQueue<ResourceRequest> requestQueue = new LinkedBlockingQueue<ResourceRequest>();

    ResourceRequestQueue() {
    }

    void add(ResourceRequest req) {
        this.requestQueue.add(req);
    }

    boolean hasOutStandingRequests() {
        return !this.requestQueue.isEmpty();
    }

    synchronized ResourceRequestEvent satisfyOne() {
        ResourceRequest req = (ResourceRequest)this.requestQueue.element();
        req.satisfyOne();
        if (req.isSatisfied()) {
            this.requestQueue.poll();
        }
        return req.getRequestProto();
    }

    synchronized int getNumberOfOutstandingRequests() {
        return this.requestQueue.size();
    }

    synchronized ResourceRequest head() {
        return (ResourceRequest)this.requestQueue.element();
    }
}

