/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.local.process;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.runtime.local.process.RunnableProcessObserver;

public final class LoggingRunnableProcessObserver
implements RunnableProcessObserver {
    private static final Logger LOG = Logger.getLogger(LoggingRunnableProcessObserver.class.getName());

    @Override
    public void onProcessStarted(String processId) {
        LOG.log(Level.FINE, "Process {0} started.", processId);
    }

    @Override
    public void onProcessExit(String processId, int exitCode) {
        if (exitCode == 0) {
            LOG.log(Level.FINE, "Process {0} exited with return code 0.", processId);
        } else {
            LOG.log(Level.WARNING, "Process {0} exited with return code {1}.", new Object[]{processId, exitCode});
        }
    }
}

