/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.local.process;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import net.jcip.annotations.ThreadSafe;
import org.apache.reef.runtime.common.driver.api.RuntimeParameters;
import org.apache.reef.runtime.common.driver.evaluator.pojos.State;
import org.apache.reef.runtime.common.driver.resourcemanager.ResourceStatusEvent;
import org.apache.reef.runtime.common.driver.resourcemanager.ResourceStatusEventImpl;
import org.apache.reef.runtime.local.driver.ResourceManager;
import org.apache.reef.runtime.local.process.RunnableProcessObserver;
import org.apache.reef.tang.InjectionFuture;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.wake.EventHandler;

@ThreadSafe
public final class ReefRunnableProcessObserver
implements RunnableProcessObserver {
    private static final Logger LOG = Logger.getLogger(ReefRunnableProcessObserver.class.getName());
    private final EventHandler<ResourceStatusEvent> resourceStatusHandler;
    private final InjectionFuture<ResourceManager> resourceManager;

    @Inject
    public ReefRunnableProcessObserver(@Parameter(value=RuntimeParameters.ResourceStatusHandler.class) EventHandler<ResourceStatusEvent> resourceStatusHandler, InjectionFuture<ResourceManager> resourceManager) {
        this.resourceStatusHandler = resourceStatusHandler;
        this.resourceManager = resourceManager;
    }

    @Override
    public void onProcessStarted(String processId) {
        this.onResourceStatus(ResourceStatusEventImpl.newBuilder().setIdentifier(processId).setState(State.RUNNING).build());
    }

    @Override
    public void onProcessExit(String processId, int exitCode) {
        switch (exitCode) {
            case 0: {
                this.onCleanExit(processId);
                break;
            }
            default: {
                this.onUncleanExit(processId, exitCode);
            }
        }
        ((ResourceManager)this.resourceManager.get()).onEvaluatorExit(processId);
    }

    private void onCleanExit(String processId) {
        this.onResourceStatus(ResourceStatusEventImpl.newBuilder().setIdentifier(processId).setState(State.DONE).setExitCode(0).build());
    }

    private void onUncleanExit(String processId, int exitCode) {
        this.onResourceStatus(ResourceStatusEventImpl.newBuilder().setIdentifier(processId).setState(State.FAILED).setExitCode(exitCode).build());
    }

    private void onResourceStatus(ResourceStatusEvent resourceStatus) {
        LOG.log(Level.INFO, "Sending resource status: {0} ", resourceStatus);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            LOG.log(Level.FINEST, "Sleep interrupted. Event will be fired earlier than usual.");
        }
        this.resourceStatusHandler.onNext((Object)resourceStatus);
    }
}

