/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.local.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.runtime.local.process.RunnableProcessObserver;
import org.apache.reef.util.OSUtils;

public final class RunnableProcess
implements Runnable {
    private static final Logger LOG = Logger.getLogger(RunnableProcess.class.getName());
    private static final long DESTROY_WAIT_TIME = 100L;
    private final String standardErrorFileName;
    private final String standardOutFileName;
    private final List<String> command;
    private final String id;
    private final File folder;
    private final Lock stateLock = new ReentrantLock();
    private final Condition doneCond = this.stateLock.newCondition();
    private final RunnableProcessObserver processObserver;
    private Process process;
    private State state = State.INIT;

    public RunnableProcess(List<String> command, String id, File folder, RunnableProcessObserver processObserver, String standardOutFileName, String standardErrorFileName) {
        this.processObserver = processObserver;
        this.command = new ArrayList<String>(command);
        this.id = id;
        this.folder = folder;
        assert (this.folder.isDirectory());
        if (!this.folder.exists() && !this.folder.mkdirs()) {
            LOG.log(Level.WARNING, "Failed to create [{0}]", this.folder.getAbsolutePath());
        }
        this.standardOutFileName = standardOutFileName;
        this.standardErrorFileName = standardErrorFileName;
        LOG.log(Level.FINEST, "RunnableProcess ready.");
    }

    private static boolean isLegal(State from, State to) {
        switch (from) {
            case INIT: {
                switch (to) {
                    case INIT: 
                    case RUNNING: 
                    case ENDED: {
                        return true;
                    }
                }
                return false;
            }
            case RUNNING: {
                switch (to) {
                    case ENDED: {
                        return true;
                    }
                }
                return false;
            }
            case ENDED: {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.stateLock.lock();
        try {
            if (this.getState() != State.INIT) {
                throw new IllegalStateException("The RunnableProcess can't be reused");
            }
            File errFile = new File(this.folder, this.standardErrorFileName);
            File outFile = new File(this.folder, this.standardOutFileName);
            try {
                LOG.log(Level.FINEST, "Launching process \"{0}\"\nSTDERR can be found in {1}\nSTDOUT can be found in {2}", new Object[]{this.id, errFile.getAbsolutePath(), outFile.getAbsolutePath()});
                this.process = new ProcessBuilder(new String[0]).command(this.command).directory(this.folder).redirectError(errFile).redirectOutput(outFile).start();
                this.setState(State.RUNNING);
                this.processObserver.onProcessStarted(this.id);
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, "Unable to spawn process \"{0}\" wth command {1}\n Exception:{2}", new Object[]{this.id, this.command, ex});
            }
        }
        finally {
            this.stateLock.unlock();
        }
        try {
            int returnValue = this.process.waitFor();
            this.processObserver.onProcessExit(this.id, returnValue);
            this.stateLock.lock();
            try {
                this.setState(State.ENDED);
                this.doneCond.signalAll();
            }
            finally {
                this.stateLock.unlock();
            }
            LOG.log(Level.FINEST, "Process \"{0}\" returned {1}", new Object[]{this.id, returnValue});
        }
        catch (InterruptedException ex) {
            LOG.log(Level.SEVERE, "Interrupted while waiting for the process \"{0}\" to complete. Exception: {2}", new Object[]{this.id, ex});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.stateLock.lock();
        try {
            if (this.processIsRunning()) {
                this.process.destroy();
                if (!this.doneCond.await(100L, TimeUnit.MILLISECONDS)) {
                    LOG.log(Level.FINE, "{0} milliseconds elapsed", 100L);
                }
            }
            if (this.processIsRunning()) {
                LOG.log(Level.WARNING, "The child process survived Process.destroy()");
                if (OSUtils.isUnix() || OSUtils.isWindows()) {
                    LOG.log(Level.WARNING, "Attempting to kill the process via the kill command line");
                    try {
                        long pid = this.readPID();
                        OSUtils.kill((long)pid);
                    }
                    catch (IOException | InterruptedException | NumberFormatException e) {
                        LOG.log(Level.SEVERE, "Unable to kill the process.", e);
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            LOG.log(Level.SEVERE, "Interrupted while waiting for the process \"{0}\" to complete. Exception: {2}", new Object[]{this.id, ex});
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private long readPID() throws IOException {
        String pidFileName = this.folder.getAbsolutePath() + "/" + "PID.txt";
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(pidFileName), StandardCharsets.UTF_8));){
            long l = Long.parseLong(r.readLine());
            return l;
        }
    }

    private boolean processIsRunning() {
        return this.getState() == State.RUNNING;
    }

    private State getState() {
        return this.state;
    }

    private void setState(State newState) {
        if (!RunnableProcess.isLegal(this.state, newState)) {
            throw new IllegalStateException("Transition from " + (Object)((Object)this.state) + " to " + (Object)((Object)newState) + " is illegal");
        }
        this.state = newState;
    }

    private static enum State {
        INIT,
        RUNNING,
        ENDED;

    }
}

