/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.statistics;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.rocketmq.common.statistics.StatisticsBriefInterceptor;
import org.apache.rocketmq.common.statistics.StatisticsItem;
import org.apache.rocketmq.common.statistics.StatisticsItemStateGetter;
import org.apache.rocketmq.common.statistics.StatisticsKindMeta;
import org.apache.rocketmq.common.utils.ThreadUtils;

public class StatisticsManager {
    private Map<String, StatisticsKindMeta> kindMetaMap;
    private Pair<String, long[][]>[] briefMetas;
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, StatisticsItem>> statsTable = new ConcurrentHashMap();
    private static final int MAX_IDLE_TIME = 600000;
    private final ScheduledExecutorService executor = ThreadUtils.newSingleThreadScheduledExecutor("StatisticsManagerCleaner", true);
    private StatisticsItemStateGetter statisticsItemStateGetter;

    public StatisticsManager() {
        this.kindMetaMap = new HashMap<String, StatisticsKindMeta>();
        this.start();
    }

    public StatisticsManager(Map<String, StatisticsKindMeta> kindMeta) {
        this.kindMetaMap = kindMeta;
        this.start();
    }

    public void addStatisticsKindMeta(StatisticsKindMeta kindMeta) {
        this.kindMetaMap.put(kindMeta.getName(), kindMeta);
        this.statsTable.putIfAbsent(kindMeta.getName(), new ConcurrentHashMap(16));
    }

    public void setBriefMeta(Pair<String, long[][]>[] briefMetas) {
        this.briefMetas = briefMetas;
    }

    private void start() {
        int maxIdleTime = 600000;
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : StatisticsManager.this.statsTable.entrySet()) {
                    String kind = (String)entry.getKey();
                    ConcurrentHashMap itemMap = (ConcurrentHashMap)entry.getValue();
                    if (itemMap == null || itemMap.isEmpty()) continue;
                    HashMap tmpItemMap = new HashMap(itemMap);
                    for (StatisticsItem item : tmpItemMap.values()) {
                        if (System.currentTimeMillis() - item.getLastTimeStamp().get() <= 600000L || StatisticsManager.this.statisticsItemStateGetter != null && StatisticsManager.this.statisticsItemStateGetter.online(item)) continue;
                        StatisticsManager.this.remove(item);
                    }
                }
            }
        }, maxIdleTime, maxIdleTime / 3, TimeUnit.MILLISECONDS);
    }

    public boolean inc(String kind, String key, long ... itemAccumulates) {
        ConcurrentHashMap<String, StatisticsItem> itemMap = this.statsTable.get(kind);
        if (itemMap != null) {
            StatisticsItem item = itemMap.get(key);
            if (item == null) {
                item = new StatisticsItem(kind, key, this.kindMetaMap.get(kind).getItemNames());
                item.setInterceptor(new StatisticsBriefInterceptor(item, this.briefMetas));
                StatisticsItem oldItem = itemMap.putIfAbsent(key, item);
                if (oldItem != null) {
                    item = oldItem;
                } else {
                    this.scheduleStatisticsItem(item);
                }
            }
            item.incItems(itemAccumulates);
            return true;
        }
        return false;
    }

    private void scheduleStatisticsItem(StatisticsItem item) {
        this.kindMetaMap.get(item.getStatKind()).getScheduledPrinter().schedule(item);
    }

    public void remove(StatisticsItem item) {
        StatisticsKindMeta kindMeta;
        ConcurrentHashMap<String, StatisticsItem> itemMap = this.statsTable.get(item.getStatKind());
        if (itemMap != null) {
            itemMap.remove(item.getStatObject(), item);
        }
        if ((kindMeta = this.kindMetaMap.get(item.getStatKind())) != null && kindMeta.getScheduledPrinter() != null) {
            kindMeta.getScheduledPrinter().remove(item);
        }
    }

    public StatisticsItemStateGetter getStatisticsItemStateGetter() {
        return this.statisticsItemStateGetter;
    }

    public void setStatisticsItemStateGetter(StatisticsItemStateGetter statisticsItemStateGetter) {
        this.statisticsItemStateGetter = statisticsItemStateGetter;
    }
}

