/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spring.autoconfigure;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.spring.annotation.ExtRocketMQTemplateConfiguration;
import org.apache.rocketmq.spring.autoconfigure.RocketMQProperties;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.apache.rocketmq.spring.support.RocketMQMessageConverter;
import org.apache.rocketmq.spring.support.RocketMQUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

@Configuration
public class ExtProducerResetConfiguration
implements ApplicationContextAware,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(ExtProducerResetConfiguration.class);
    private ConfigurableApplicationContext applicationContext;
    private ConfigurableEnvironment environment;
    private RocketMQProperties rocketMQProperties;
    private RocketMQMessageConverter rocketMQMessageConverter;

    public ExtProducerResetConfiguration(RocketMQMessageConverter rocketMQMessageConverter, ConfigurableEnvironment environment, RocketMQProperties rocketMQProperties) {
        this.rocketMQMessageConverter = rocketMQMessageConverter;
        this.environment = environment;
        this.rocketMQProperties = rocketMQProperties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void afterSingletonsInstantiated() {
        Map<String, Object> beans = this.applicationContext.getBeansWithAnnotation(ExtRocketMQTemplateConfiguration.class).entrySet().stream().filter(entry -> !ScopedProxyUtils.isScopedTarget((String)((String)entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        beans.forEach(this::registerTemplate);
    }

    private void registerTemplate(String beanName, Object bean) {
        Class clazz = AopProxyUtils.ultimateTargetClass((Object)bean);
        if (!RocketMQTemplate.class.isAssignableFrom(bean.getClass())) {
            throw new IllegalStateException(clazz + " is not instance of " + RocketMQTemplate.class.getName());
        }
        ExtRocketMQTemplateConfiguration annotation = clazz.getAnnotation(ExtRocketMQTemplateConfiguration.class);
        GenericApplicationContext genericApplicationContext = (GenericApplicationContext)this.applicationContext;
        this.validate(annotation, genericApplicationContext);
        DefaultMQProducer mqProducer = this.createProducer(annotation);
        try {
            mqProducer.start();
        }
        catch (MQClientException e) {
            throw new BeanDefinitionValidationException(String.format("Failed to startup MQProducer for RocketMQTemplate {}", beanName), (Throwable)e);
        }
        RocketMQTemplate rocketMQTemplate = (RocketMQTemplate)((Object)bean);
        rocketMQTemplate.setProducer(mqProducer);
        rocketMQTemplate.setMessageConverter(this.rocketMQMessageConverter.getMessageConverter());
        log.info("Set real producer to :{} {}", (Object)beanName, (Object)annotation.value());
    }

    private DefaultMQProducer createProducer(ExtRocketMQTemplateConfiguration annotation) {
        RocketMQProperties.Producer producerConfig = this.rocketMQProperties.getProducer();
        if (producerConfig == null) {
            producerConfig = new RocketMQProperties.Producer();
        }
        String nameServer = this.environment.resolvePlaceholders(annotation.nameServer());
        String groupName = this.environment.resolvePlaceholders(annotation.group());
        groupName = !StringUtils.hasLength((String)groupName) ? producerConfig.getGroup() : groupName;
        String ak = this.environment.resolvePlaceholders(annotation.accessKey());
        ak = StringUtils.hasLength((String)ak) ? ak : producerConfig.getAccessKey();
        String sk = this.environment.resolvePlaceholders(annotation.secretKey());
        sk = StringUtils.hasLength((String)sk) ? sk : producerConfig.getSecretKey();
        boolean isEnableMsgTrace = annotation.enableMsgTrace();
        String customizedTraceTopic = this.environment.resolvePlaceholders(annotation.customizedTraceTopic());
        customizedTraceTopic = StringUtils.hasLength((String)customizedTraceTopic) ? customizedTraceTopic : producerConfig.getCustomizedTraceTopic();
        boolean useTLS = new Boolean(this.environment.resolvePlaceholders(annotation.tlsEnable()));
        DefaultMQProducer producer = RocketMQUtil.createDefaultMQProducer(groupName, ak, sk, isEnableMsgTrace, customizedTraceTopic);
        producer.setNamesrvAddr(nameServer);
        producer.setSendMsgTimeout(annotation.sendMessageTimeout() == -1 ? producerConfig.getSendMessageTimeout() : annotation.sendMessageTimeout());
        producer.setRetryTimesWhenSendFailed(annotation.retryTimesWhenSendFailed() == -1 ? producerConfig.getRetryTimesWhenSendFailed() : annotation.retryTimesWhenSendFailed());
        producer.setRetryTimesWhenSendAsyncFailed(annotation.retryTimesWhenSendAsyncFailed() == -1 ? producerConfig.getRetryTimesWhenSendAsyncFailed() : annotation.retryTimesWhenSendAsyncFailed());
        producer.setMaxMessageSize(annotation.maxMessageSize() == -1 ? producerConfig.getMaxMessageSize() : annotation.maxMessageSize());
        producer.setCompressMsgBodyOverHowmuch(annotation.compressMessageBodyThreshold() == -1 ? producerConfig.getCompressMessageBodyThreshold() : annotation.compressMessageBodyThreshold());
        producer.setRetryAnotherBrokerWhenNotStoreOK(annotation.retryNextServer());
        producer.setUseTLS(useTLS);
        String namespace = this.environment.resolvePlaceholders(annotation.namespace());
        producer.setNamespace(RocketMQUtil.getNamespace(namespace, producerConfig.getNamespace()));
        producer.setInstanceName(annotation.instanceName());
        return producer;
    }

    private void validate(ExtRocketMQTemplateConfiguration annotation, GenericApplicationContext genericApplicationContext) {
        if (genericApplicationContext.isBeanNameInUse(annotation.value())) {
            throw new BeanDefinitionValidationException(String.format("Bean {} has been used in Spring Application Context, please check the @ExtRocketMQTemplateConfiguration", annotation.value()));
        }
    }
}

