/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.js.JsException;
import org.apache.shindig.gadgets.js.JsProcessor;
import org.apache.shindig.gadgets.js.JsRequest;
import org.apache.shindig.gadgets.js.JsResponseBuilder;
import org.apache.shindig.gadgets.uri.JsUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;

public class JsLoadProcessor
implements JsProcessor {
    private static final String CODE_ID = "[jsloader-bootstrap]";
    @VisibleForTesting
    public static final String JSLOAD_ONLOAD_ERROR = "jsload requires onload";
    @VisibleForTesting
    public static final String JSLOAD_JS_TPL = "(function() {document.write('<scr' + 'ipt type=\"text/javascript\" src=\"%s\"></scr' + 'ipt>');})();";
    @VisibleForTesting
    public static final String ASYNC_JSLOAD_JS_TPL = "(function() {var s=document.createElement('script');s.src=\"%s\";document.getElementsByTagName('head')[0].appendChild(s);})();";
    private final JsUriManager jsUriManager;
    private final int jsloadTtlSecs;
    private final boolean requireOnload;
    private String template;

    @Inject
    public JsLoadProcessor(JsUriManager jsUriManager, @Named(value="shindig.jsload.ttl-secs") int jsloadTtlSecs, @Named(value="shindig.jsload.require-onload-with-jsload") boolean requireOnload) {
        this.jsUriManager = jsUriManager;
        this.jsloadTtlSecs = jsloadTtlSecs;
        this.requireOnload = requireOnload;
        this.template = JSLOAD_JS_TPL;
    }

    @Inject(optional=true)
    public void setUseAsync(@Named(value="shindig.jsload.async-mode") Boolean jsloadAsync) {
        if (jsloadAsync.booleanValue()) {
            this.template = ASYNC_JSLOAD_JS_TPL;
        }
    }

    @Override
    public boolean process(JsRequest request, JsResponseBuilder builder) throws JsException {
        JsUriManager.JsUri jsUri = request.getJsUri();
        if (jsUri.isJsload()) {
            if (this.requireOnload && jsUri.getOnload() == null) {
                throw new JsException(400, JSLOAD_ONLOAD_ERROR);
            }
            int refresh = this.getCacheTtlSecs(jsUri);
            builder.setCacheTtlSecs(refresh);
            builder.setProxyCacheable(true);
            this.doJsload(jsUri, builder);
            return false;
        }
        return true;
    }

    protected void doJsload(JsUriManager.JsUri jsUri, JsResponseBuilder resp) throws JsException {
        jsUri.setJsload(false);
        jsUri.setNohint(true);
        Uri incUri = this.jsUriManager.makeExternJsUri(jsUri);
        incUri = new UriBuilder(incUri).addQueryParameter(UriCommon.Param.JSLOAD.getKey(), "0").toUri();
        resp.appendJs(this.createJsloadScript(incUri), CODE_ID);
    }

    protected String createJsloadScript(Uri uri) {
        String uriString = uri.toString();
        return String.format(this.template, uriString);
    }

    private int getCacheTtlSecs(JsUriManager.JsUri jsUri) {
        if (jsUri.isNoCache()) {
            return 0;
        }
        Integer jsUriRefresh = jsUri.getRefresh();
        return jsUriRefresh != null && jsUriRefresh >= 0 ? jsUriRefresh : this.jsloadTtlSecs;
    }
}

