/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.shindig.common.servlet.Authority;
import org.apache.shindig.gadgets.oauth2.OAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2CallbackState;
import org.apache.shindig.gadgets.oauth2.OAuth2Error;
import org.apache.shindig.gadgets.oauth2.OAuth2Store;
import org.apache.shindig.gadgets.oauth2.OAuth2Token;

public class BasicOAuth2Accessor
implements OAuth2Accessor {
    private static final long serialVersionUID = 2050065428260384933L;
    private OAuth2Token accessToken;
    private final boolean allowModuleOverrides;
    private boolean authorizationHeader;
    private String authorizationUrl;
    private String clientAuthenticationType;
    private String clientId;
    private byte[] clientSecret;
    private OAuth2Error error;
    private String errorContextMessage;
    private Throwable errorException;
    private boolean errorResponse;
    private String errorUri;
    private final String gadgetUri;
    private final String globalRedirectUri;
    private final transient Authority authority;
    private final transient String contextRoot;
    private String grantType;
    private boolean redirecting;
    private String redirectUri;
    private OAuth2Token refreshToken;
    private final String scope;
    private final String serviceName;
    private transient OAuth2CallbackState state;
    private String tokenUrl;
    private OAuth2Accessor.Type type;
    private boolean urlParameter;
    private final String user;
    private Map<String, String> additionalRequestParams;
    private String[] allowedDomains;

    public BasicOAuth2Accessor() {
        this(null, null, null, null, false, null, null, null, null);
    }

    BasicOAuth2Accessor(Throwable exception, OAuth2Error error, String contextMessage, String errorUri) {
        this.serviceName = null;
        this.scope = null;
        this.state = null;
        this.tokenUrl = null;
        this.type = null;
        this.user = null;
        this.gadgetUri = null;
        this.globalRedirectUri = null;
        this.authority = null;
        this.contextRoot = null;
        this.allowModuleOverrides = false;
        this.additionalRequestParams = Maps.newHashMap();
        this.setErrorResponse(exception, error, contextMessage, errorUri);
    }

    public BasicOAuth2Accessor(OAuth2Accessor accessor) {
        this.accessToken = accessor.getAccessToken();
        this.authorizationUrl = accessor.getAuthorizationUrl();
        this.clientAuthenticationType = accessor.getClientAuthenticationType();
        this.authorizationHeader = accessor.isAuthorizationHeader();
        this.urlParameter = accessor.isUrlParameter();
        this.clientId = accessor.getClientId();
        this.clientSecret = accessor.getClientSecret();
        this.gadgetUri = accessor.getGadgetUri();
        this.grantType = accessor.getGrantType();
        this.redirectUri = accessor.getRedirectUri();
        this.refreshToken = accessor.getRefreshToken();
        this.serviceName = accessor.getServiceName();
        this.scope = accessor.getScope();
        this.state = accessor.getState();
        this.tokenUrl = accessor.getTokenUrl();
        this.type = accessor.getType();
        this.user = accessor.getUser();
        this.allowModuleOverrides = false;
        this.globalRedirectUri = null;
        this.authority = null;
        this.contextRoot = null;
        this.errorResponse = accessor.isErrorResponse();
        this.redirecting = accessor.isRedirecting();
        this.error = accessor.getError();
        this.errorContextMessage = accessor.getErrorContextMessage();
        this.errorException = accessor.getErrorException();
        this.errorUri = accessor.getErrorUri();
        this.additionalRequestParams = Maps.newHashMap();
        this.allowedDomains = accessor.getAllowedDomains();
    }

    public BasicOAuth2Accessor(String gadgetUri, String serviceName, String user, String scope, boolean allowModuleOverrides, OAuth2Store store, String globalRedirectUri, Authority authority, String contextRoot) {
        this.gadgetUri = gadgetUri;
        this.serviceName = serviceName;
        this.user = user;
        this.scope = scope;
        this.allowModuleOverrides = allowModuleOverrides;
        this.globalRedirectUri = globalRedirectUri;
        this.state = store != null ? new OAuth2CallbackState(store.getStateCrypter()) : new OAuth2CallbackState();
        this.state.setGadgetUri(gadgetUri);
        this.state.setServiceName(serviceName);
        this.state.setUser(user);
        this.state.setScope(scope);
        this.authority = authority;
        this.contextRoot = contextRoot;
        this.errorResponse = false;
        this.redirecting = false;
        this.additionalRequestParams = Maps.newHashMap();
    }

    @Override
    public OAuth2Token getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    @Override
    public String getClientAuthenticationType() {
        return this.clientAuthenticationType;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public byte[] getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public OAuth2Error getError() {
        return this.error;
    }

    @Override
    public String getErrorContextMessage() {
        return this.errorContextMessage;
    }

    @Override
    public Throwable getErrorException() {
        return this.errorException;
    }

    @Override
    public String getErrorUri() {
        return this.errorUri;
    }

    @Override
    public String getGadgetUri() {
        return this.gadgetUri;
    }

    @Override
    public String getGrantType() {
        return this.grantType;
    }

    @Override
    public String getRedirectUri() {
        if (this.redirectUri == null || this.redirectUri.length() == 0) {
            String redirectUri2 = this.globalRedirectUri;
            if (this.authority != null) {
                redirectUri2 = redirectUri2.replace("%authority%", this.authority.getAuthority());
                redirectUri2 = redirectUri2.replace("%contextRoot%", this.contextRoot);
                redirectUri2 = redirectUri2.replace("%origin%", this.authority.getOrigin());
            }
            this.redirectUri = redirectUri2;
        }
        return this.redirectUri;
    }

    @Override
    public OAuth2Token getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public Map<String, String> getAdditionalRequestParams() {
        return this.additionalRequestParams;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public OAuth2CallbackState getState() {
        if (this.state == null) {
            return new OAuth2CallbackState(null);
        }
        return this.state;
    }

    @Override
    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @Override
    public OAuth2Accessor.Type getType() {
        return this.type;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void invalidate() {
        this.accessToken = null;
        this.authorizationUrl = null;
        this.clientAuthenticationType = null;
        this.clientId = null;
        this.clientSecret = null;
        this.grantType = null;
        this.redirectUri = null;
        this.refreshToken = null;
        this.tokenUrl = null;
        this.type = null;
        this.errorResponse = false;
        this.redirecting = false;
        this.errorException = null;
    }

    @Override
    public boolean isAllowModuleOverrides() {
        return this.allowModuleOverrides;
    }

    @Override
    public boolean isAuthorizationHeader() {
        return this.authorizationHeader;
    }

    @Override
    public boolean isErrorResponse() {
        return this.errorResponse;
    }

    @Override
    public boolean isRedirecting() {
        return this.redirecting;
    }

    @Override
    public boolean isUrlParameter() {
        return this.urlParameter;
    }

    @Override
    public boolean isValid() {
        return this.grantType != null;
    }

    @Override
    public void setAccessToken(OAuth2Token accessToken) {
        this.accessToken = accessToken;
    }

    public void setAuthorizationHeader(boolean authorizationHeader) {
        this.authorizationHeader = authorizationHeader;
    }

    @Override
    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    public void setClientAuthenticationType(String clientAuthenticationType) {
        this.clientAuthenticationType = clientAuthenticationType;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(byte[] clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Override
    public void setErrorResponse(Throwable exception, OAuth2Error error, String contextMessage, String errorUri) {
        this.errorResponse = true;
        this.errorException = exception;
        if (error != null) {
            this.error = error;
            this.errorContextMessage = contextMessage;
            this.errorUri = errorUri;
        }
    }

    public void setErrorUri(String errorUri) {
        this.errorUri = errorUri;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    @Override
    public void setRedirecting(boolean redirecting) {
        this.redirecting = redirecting;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    @Override
    public void setRefreshToken(OAuth2Token refreshToken) {
        this.refreshToken = refreshToken;
    }

    @Override
    public void setAdditionalRequestParams(Map<String, String> additionalRequestParams) {
        this.additionalRequestParams = additionalRequestParams;
    }

    @Override
    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public void setType(OAuth2Accessor.Type type) {
        this.type = type;
    }

    public void setUrlParameter(boolean urlParameter) {
        this.urlParameter = urlParameter;
    }

    @Override
    public void setAllowedDomains(String[] allowedDomains) {
        this.allowedDomains = allowedDomains;
    }

    @Override
    public String[] getAllowedDomains() {
        return this.allowedDomains;
    }
}

