/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.gadgets.oauth2.OAuth2CallbackStateToken;
import org.apache.shindig.gadgets.oauth2.logger.FilteredLogger;

public class OAuth2CallbackState
implements Serializable {
    private static final long serialVersionUID = 6591011719613609006L;
    private static final String LOG_CLASS = OAuth2CallbackState.class.getName();
    private static final FilteredLogger LOG = FilteredLogger.getFilteredLogger(LOG_CLASS);
    private final transient BlobCrypter crypter;
    private OAuth2CallbackStateToken state;

    public OAuth2CallbackState() {
        this(null);
    }

    public OAuth2CallbackState(BlobCrypter crypter) {
        this.crypter = crypter;
        this.state = new OAuth2CallbackStateToken();
    }

    public OAuth2CallbackState(BlobCrypter crypter, String stateBlob) {
        Map state;
        block5: {
            this.crypter = crypter;
            state = null;
            if (stateBlob != null && crypter != null) {
                try {
                    state = crypter.unwrap(stateBlob);
                    if (state == null) {
                        state = Maps.newHashMap();
                    }
                    this.state = new OAuth2CallbackStateToken(state);
                    this.state.enforceNotExpired();
                }
                catch (BlobCrypterException e) {
                    state = null;
                    if (!LOG.isLoggable()) break block5;
                    LOG.log("OAuth2CallbackState stateBlob decryption failed", e);
                }
            }
        }
        if (state == null) {
            this.state = new OAuth2CallbackStateToken();
        }
    }

    public String getEncryptedState() throws BlobCrypterException {
        String ret = null;
        if (this.crypter != null) {
            ret = this.crypter.wrap(this.state.toMap());
        }
        return ret;
    }

    public String getGadgetUri() {
        return this.state.getGadgetUri();
    }

    public void setGadgetUri(String gadgetUri) {
        this.state.setGadgetUri(gadgetUri);
    }

    public String getServiceName() {
        return this.state.getServiceName();
    }

    public void setServiceName(String serviceName) {
        this.state.setServiceName(serviceName);
    }

    public String getUser() {
        return this.state.getUser();
    }

    public void setUser(String user) {
        this.state.setUser(user);
    }

    public String getScope() {
        return this.state.getScope();
    }

    public void setScope(String scope) {
        this.state.setScope(scope);
    }
}

