/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2.handler;

import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.oauth2.OAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2Error;
import org.apache.shindig.gadgets.oauth2.handler.ClientAuthenticationHandler;
import org.apache.shindig.gadgets.oauth2.handler.OAuth2HandlerError;

public class StandardAuthenticationHandler
implements ClientAuthenticationHandler {
    private static final OAuth2Error ERROR = OAuth2Error.AUTHENTICATION_PROBLEM;

    @Override
    public OAuth2HandlerError addOAuth2Authentication(HttpRequest request, OAuth2Accessor accessor) {
        try {
            if (request == null) {
                return StandardAuthenticationHandler.getError("request is null");
            }
            if (accessor == null) {
                return StandardAuthenticationHandler.getError("accessor is null");
            }
            if (!accessor.isValid() || accessor.isErrorResponse()) {
                return StandardAuthenticationHandler.getError("accessor is invalid");
            }
            String clientId = accessor.getClientId();
            if (clientId == null) {
                return StandardAuthenticationHandler.getError("client_id is null");
            }
            byte[] secretBytes = accessor.getClientSecret();
            if (secretBytes == null) {
                return StandardAuthenticationHandler.getError("client_secret is secret");
            }
            String secret = new String(secretBytes, "UTF-8");
            request.setHeader("client_id", clientId);
            request.setParam("client_id", clientId);
            request.setHeader("client_secret", secret);
            request.setParam("client_secret", secret);
            return null;
        }
        catch (Exception e) {
            return StandardAuthenticationHandler.getError("Exception adding standard auth headers", e);
        }
    }

    @Override
    public String geClientAuthenticationType() {
        return "STANDARD";
    }

    private static OAuth2HandlerError getError(String contextMessage) {
        return StandardAuthenticationHandler.getError(contextMessage, null);
    }

    private static OAuth2HandlerError getError(String contextMessage, Exception e) {
        return new OAuth2HandlerError(ERROR, contextMessage, e);
    }
}

