/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2.persistence.sample;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.gadgets.oauth2.OAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2CallbackState;
import org.apache.shindig.gadgets.oauth2.OAuth2Token;
import org.apache.shindig.gadgets.oauth2.persistence.MapCache;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2Client;

@Singleton
public class InMemoryCache
extends MapCache {
    private final Map<String, OAuth2Accessor> accessors;
    private final Map<String, OAuth2Client> clients;
    private final Map<String, OAuth2Token> tokens;

    @Inject
    public InMemoryCache() {
        HashMap tMap = Maps.newHashMap();
        this.tokens = Collections.synchronizedMap(tMap);
        HashMap cMap = Maps.newHashMap();
        this.clients = Collections.synchronizedMap(cMap);
        HashMap aMap = Maps.newHashMap();
        this.accessors = Collections.synchronizedMap(aMap);
    }

    @Override
    protected Map<String, OAuth2Client> getClientMap() {
        return this.clients;
    }

    @Override
    protected Map<String, OAuth2Token> getTokenMap() {
        return this.tokens;
    }

    @Override
    protected Map<String, OAuth2Accessor> getAccessorMap() {
        return this.accessors;
    }

    @Override
    protected String getClientKey(OAuth2Client client) {
        return super.getClientKey(client);
    }

    @Override
    protected String getClientKey(String gadgetUri, String serviceName) {
        return super.getClientKey(gadgetUri, serviceName);
    }

    @Override
    protected String getAccessorKey(OAuth2CallbackState state) {
        return super.getAccessorKey(state);
    }

    @Override
    protected String getAccessorKey(OAuth2Accessor accessor) {
        return super.getAccessorKey(accessor);
    }

    @Override
    protected String getTokenKey(String gadgetUri, String serviceName, String user, String scope, OAuth2Token.Type type) {
        return super.getTokenKey(gadgetUri, serviceName, user, scope, type);
    }

    @Override
    protected String getTokenKey(OAuth2Token token) {
        return super.getTokenKey(token);
    }
}

