/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.DefaultHtmlSerializer;
import org.apache.shindig.gadgets.parse.HtmlSerialization;
import org.apache.shindig.gadgets.parse.HtmlSerializer;
import org.apache.shindig.gadgets.parse.SocialDataTags;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class GadgetHtmlParser {
    private static final String classname = GadgetHtmlParser.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    public static final String PARSED_DOCUMENTS = "parsedDocuments";
    public static final String PARSED_FRAGMENTS = "parsedFragments";
    private Cache<String, Document> documentCache;
    private Cache<String, DocumentFragment> fragmentCache;
    private Provider<HtmlSerializer> serializerProvider = new DefaultSerializerProvider();
    protected final DOMImplementation documentFactory;

    protected GadgetHtmlParser(DOMImplementation documentFactory) {
        this.documentFactory = documentFactory;
    }

    protected GadgetHtmlParser(DOMImplementation documentFactory, final HtmlSerializer serializer) {
        this.documentFactory = documentFactory;
        this.serializerProvider = new Provider<HtmlSerializer>(){

            public HtmlSerializer get() {
                return serializer;
            }
        };
    }

    @Inject
    public void setCacheProvider(CacheProvider cacheProvider) {
        this.documentCache = cacheProvider.createCache(PARSED_DOCUMENTS);
        this.fragmentCache = cacheProvider.createCache(PARSED_FRAGMENTS);
    }

    @Inject
    public void setSerializerProvider(Provider<HtmlSerializer> serProvider) {
        this.serializerProvider = serProvider;
    }

    protected static boolean attemptFullDocParseFirst(String content) {
        String normalized = content.substring(0, Math.min(100, content.length())).toUpperCase();
        return normalized.contains("<!DOCTYPE") || normalized.contains("<HTML");
    }

    public Document parseDom(String source) throws GadgetException {
        Document document = null;
        String key = null;
        boolean shouldCache = this.shouldCache();
        if (shouldCache) {
            key = HashUtil.checksum((byte[])source.getBytes());
            document = (Document)this.documentCache.getElement((Object)key);
        }
        if (document == null) {
            try {
                document = this.parseDomImpl(source);
            }
            catch (DOMException e) {
                document = this.errorDom(e);
                HtmlSerialization.attach(document, (HtmlSerializer)this.serializerProvider.get(), source);
                return document;
            }
            catch (NullPointerException e) {
                throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, "Caught exception in parseDomImpl", e);
            }
            HtmlSerialization.attach(document, (HtmlSerializer)this.serializerProvider.get(), source);
            Element html = document.getDocumentElement();
            Node head = null;
            Node body = null;
            LinkedList beforeHead = Lists.newLinkedList();
            LinkedList beforeBody = Lists.newLinkedList();
            while (html.hasChildNodes()) {
                Node child = html.removeChild(html.getFirstChild());
                if (child.getNodeType() == 1 && "head".equalsIgnoreCase(child.getNodeName())) {
                    if (head == null) {
                        head = child;
                        continue;
                    }
                    this.transferChildren(head, child);
                    continue;
                }
                if (child.getNodeType() == 1 && "body".equalsIgnoreCase(child.getNodeName())) {
                    if (body == null) {
                        body = child;
                        continue;
                    }
                    this.transferChildren(body, child);
                    continue;
                }
                if (head == null) {
                    beforeHead.add(child);
                    continue;
                }
                if (body == null) {
                    beforeBody.add(child);
                    continue;
                }
                body.appendChild(child);
            }
            if (head == null) {
                LinkedList temp = beforeBody;
                beforeBody = beforeHead;
                beforeHead = temp;
                head = document.createElement("head");
                html.insertBefore(head, html.getFirstChild());
            } else {
                html.appendChild(head);
            }
            if (body == null) {
                body = document.createElement("body");
                html.insertBefore(body, head.getNextSibling());
            } else {
                html.appendChild(body);
            }
            this.prependToNode(head, beforeHead);
            this.prependToNode(body, beforeBody);
            LinkedList styleNodes = Lists.newLinkedList();
            NodeList bodyKids = body.getChildNodes();
            for (int i = 0; i < bodyKids.getLength(); ++i) {
                Node bodyKid = bodyKids.item(i);
                if (bodyKid.getNodeType() != 1 || !this.isStyleElement((Element)bodyKid)) continue;
                styleNodes.add(bodyKid);
            }
            for (Node styleNode : styleNodes) {
                head.appendChild(body.removeChild(styleNode));
            }
            this.reprocessScriptForOpenSocial(html);
            if (shouldCache) {
                this.documentCache.addElement((Object)key, (Object)document);
            }
        }
        if (shouldCache) {
            Document copy = (Document)document.cloneNode(true);
            HtmlSerialization.copySerializer(document, copy);
            return copy;
        }
        return document;
    }

    protected void transferChildren(Node to, Node from) {
        while (from.hasChildNodes()) {
            to.appendChild(from.removeChild(from.getFirstChild()));
        }
    }

    protected void prependToNode(Node to, LinkedList<Node> from) {
        while (!from.isEmpty()) {
            to.insertBefore(from.removeLast(), to.getFirstChild());
        }
    }

    private boolean isStyleElement(Element elem) {
        return "style".equalsIgnoreCase(elem.getNodeName()) || "link".equalsIgnoreCase(elem.getNodeName()) && ("stylesheet".equalsIgnoreCase(elem.getAttribute("rel")) || elem.getAttribute("type").toLowerCase().contains("css"));
    }

    public void parseFragment(String source, Node result) throws GadgetException {
        DocumentFragment fragment;
        DocumentFragment cachedFragment;
        boolean shouldCache = this.shouldCache();
        String key = null;
        if (shouldCache && (cachedFragment = (DocumentFragment)this.fragmentCache.getElement((Object)(key = HashUtil.checksum((byte[])source.getBytes())))) != null) {
            this.copyFragment(cachedFragment, result);
            return;
        }
        try {
            fragment = this.parseFragmentImpl(source);
        }
        catch (DOMException e) {
            this.appendParseException(result, e);
            return;
        }
        this.reprocessScriptForOpenSocial(fragment);
        if (shouldCache) {
            this.fragmentCache.addElement((Object)key, (Object)fragment);
        }
        this.copyFragment(fragment, result);
    }

    private void copyFragment(DocumentFragment source, Node dest) {
        Document destDoc = dest.getOwnerDocument();
        NodeList nodes = source.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node clone = destDoc.importNode(nodes.item(i), true);
            dest.appendChild(clone);
        }
    }

    protected Document errorDom(DOMException e) {
        Document doc = this.documentFactory.createDocument(null, null, null);
        Element html = doc.createElement("html");
        html.appendChild(doc.createElement("head"));
        Element body = doc.createElement("body");
        this.appendParseException(body, e);
        html.appendChild(body);
        doc.appendChild(html);
        return doc;
    }

    private void appendParseException(Node node, DOMException e) {
        node.appendChild(node.getOwnerDocument().createTextNode(GadgetException.Code.HTML_PARSE_ERROR.toString() + ": " + e.toString()));
    }

    protected boolean shouldCache() {
        return this.documentCache != null && this.documentCache.getCapacity() != 0L;
    }

    private void reprocessScriptForOpenSocial(Node root) throws GadgetException {
        LinkedList nodeQueue = Lists.newLinkedList();
        nodeQueue.add(root);
        while (!nodeQueue.isEmpty()) {
            Attr typeAttr;
            Node next = (Node)nodeQueue.removeFirst();
            if (next.getNodeType() == 1 && "script".equalsIgnoreCase(next.getNodeName()) && (typeAttr = (Attr)next.getAttributes().getNamedItem("type")) != null && SocialDataTags.SCRIPT_TYPE_TO_OSML_TAG.get((Object)typeAttr.getValue()) != null) {
                StringBuilder sb;
                boolean parseOs;
                String osType;
                block10: {
                    osType = (String)SocialDataTags.SCRIPT_TYPE_TO_OSML_TAG.get((Object)typeAttr.getValue());
                    parseOs = true;
                    sb = new StringBuilder();
                    try {
                        next.getAttributes().removeNamedItem("type");
                        HtmlSerialization.printStartElement(osType, next.getAttributes(), sb, false);
                    }
                    catch (IOException e) {
                        if (!LOG.isLoggable(Level.INFO)) break block10;
                        LOG.logp(Level.INFO, classname, "reprocessScriptForOpenSocial", "unableToConvertScript");
                    }
                }
                NodeList scriptKids = next.getChildNodes();
                for (int i = 0; parseOs && i < scriptKids.getLength(); ++i) {
                    Node scriptKid = scriptKids.item(i);
                    if (scriptKid.getNodeType() != 3) {
                        parseOs = false;
                    }
                    sb.append(scriptKid.getTextContent());
                }
                if (parseOs) {
                    while (next.hasChildNodes()) {
                        next.removeChild(next.getFirstChild());
                    }
                    sb.append("</").append(osType).append('>');
                    DocumentFragment osFragment = this.parseFragmentImpl(sb.toString());
                    while (osFragment.hasChildNodes()) {
                        Node osKid = osFragment.removeChild(osFragment.getFirstChild());
                        osKid = next.getOwnerDocument().adoptNode(osKid);
                        if (osKid.getNodeType() != 1) continue;
                        next.getParentNode().appendChild(osKid);
                    }
                    next.getParentNode().removeChild(next);
                }
            }
            NodeList children = next.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                nodeQueue.add(children.item(i));
            }
        }
    }

    protected abstract Document parseDomImpl(String var1) throws GadgetException;

    protected abstract DocumentFragment parseFragmentImpl(String var1) throws GadgetException;

    private static class DefaultSerializerProvider
    implements Provider<HtmlSerializer> {
        private DefaultSerializerProvider() {
        }

        public HtmlSerializer get() {
            return new DefaultHtmlSerializer();
        }
    }
}

